/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.internal.changedetection.state.ConfigurableNormalizer;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipEntryContext;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.FileZipInput;
import org.gradle.api.internal.file.archive.impl.StreamZipInput;
import org.gradle.internal.file.FilePathUtil;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipHasher
implements RegularFileHasher,
ConfigurableNormalizer {
    private static final Set<String> KNOWN_ZIP_EXTENSIONS = ImmutableSet.of((Object)"zip", (Object)"jar", (Object)"war", (Object)"rar", (Object)"ear", (Object)"apk", (Object[])new String[]{"aar"});
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipHasher.class);
    private final ResourceHasher resourceHasher;
    private final ResourceFilter resourceFilter;

    public static boolean isZipFile(String name) {
        return KNOWN_ZIP_EXTENSIONS.contains(FilenameUtils.getExtension((String)name).toLowerCase(Locale.ROOT));
    }

    public ZipHasher(ResourceHasher resourceHasher, ResourceFilter resourceFilter) {
        this.resourceHasher = resourceHasher;
        this.resourceFilter = resourceFilter;
    }

    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        return this.hashZipContents(fileSnapshot);
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.getClass().getName());
        this.resourceHasher.appendConfigurationToHasher(hasher);
        this.resourceFilter.appendConfigurationToHasher(hasher);
    }

    @Nullable
    private HashCode hashZipContents(RegularFileSnapshot zipFileSnapshot) {
        try {
            List<FileSystemLocationFingerprint> fingerprints = this.fingerprintZipEntries(zipFileSnapshot.getAbsolutePath());
            if (fingerprints.isEmpty()) {
                return null;
            }
            Hasher hasher = Hashing.newHasher();
            FingerprintHashingStrategy.SORT.appendToHasher(hasher, fingerprints);
            return hasher.hash();
        }
        catch (Exception e) {
            return this.hashMalformedZip(zipFileSnapshot, e);
        }
    }

    private HashCode hashMalformedZip(RegularFileSnapshot zipFileSnapshot, Exception e) {
        LOGGER.debug("Malformed archive '{}'. Falling back to full content hash instead of entry hashing.", (Object)zipFileSnapshot.getName(), (Object)e);
        return zipFileSnapshot.getHash();
    }

    private List<FileSystemLocationFingerprint> fingerprintZipEntries(String zipFile) throws IOException {
        try (ZipInput input = FileZipInput.create((File)new File(zipFile));){
            ArrayList fingerprints = Lists.newArrayList();
            this.fingerprintZipEntries("", zipFile, fingerprints, input);
            ArrayList arrayList = fingerprints;
            return arrayList;
        }
    }

    private void fingerprintZipEntries(String parentName, String rootParentName, List<FileSystemLocationFingerprint> fingerprints, ZipInput input) throws IOException {
        fingerprints.add((FileSystemLocationFingerprint)this.newZipMarker(parentName));
        for (ZipEntry zipEntry : input) {
            ZipEntryRelativePath relativePath = new ZipEntryRelativePath(zipEntry);
            if (zipEntry.isDirectory() || this.resourceFilter.shouldBeIgnored(relativePath)) continue;
            String fullName = parentName.isEmpty() ? zipEntry.getName() : parentName + "/" + zipEntry.getName();
            ZipEntryContext zipEntryContext = new ZipEntryContext(zipEntry, fullName, rootParentName);
            if (ZipHasher.isZipFile(zipEntry.getName())) {
                this.fingerprintZipEntries(fullName, rootParentName, fingerprints, (ZipInput)new StreamZipInput(zipEntry.getInputStream()));
                continue;
            }
            this.fingerprintZipEntry(zipEntryContext, fingerprints);
        }
    }

    private void fingerprintZipEntry(ZipEntryContext zipEntryContext, List<FileSystemLocationFingerprint> fingerprints) throws IOException {
        HashCode hash = this.resourceHasher.hash(zipEntryContext);
        if (hash != null) {
            fingerprints.add((FileSystemLocationFingerprint)new DefaultFileSystemLocationFingerprint(zipEntryContext.getFullName(), FileType.RegularFile, hash));
        }
    }

    private DefaultFileSystemLocationFingerprint newZipMarker(String relativePath) {
        return new DefaultFileSystemLocationFingerprint(relativePath, FileType.RegularFile, HashCode.fromInt((int)0));
    }

    private static class ZipEntryRelativePath
    implements Supplier<String[]> {
        private final ZipEntry zipEntry;

        private ZipEntryRelativePath(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }

        @Override
        public String[] get() {
            return FilePathUtil.getPathSegments((String)this.zipEntry.getName());
        }
    }
}

