/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api;

import groovy.lang.Closure;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.internal.Cast;
import org.gradle.util.CollectionUtils;

public class InvalidActionClosureException
extends GradleException {
    private final Closure<?> closure;
    private final Object argument;

    public InvalidActionClosureException(Closure<?> closure, Object argument) {
        super(InvalidActionClosureException.toMessage(closure, argument));
        this.closure = closure;
        this.argument = argument;
    }

    private static String toMessage(Closure<?> closure, Object argument) {
        List classNames = CollectionUtils.collect((Object[])((Class[])Cast.uncheckedNonnullCast((Object)closure.getParameterTypes())), Class::getName);
        return String.format("The closure '%s' is not valid as an action for argument '%s'. It should accept no parameters, or one compatible with type '%s'. It accepts (%s).", closure, argument, argument.getClass().getName(), CollectionUtils.join((String)", ", (Iterable)classNames));
    }

    public Closure<?> getClosure() {
        return this.closure;
    }

    public Object getArgument() {
        return this.argument;
    }
}

