/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;

public class LegacyConfigurationsSupplier
implements Supplier<ImmutableList<? extends ConfigurationMetadata>> {
    private final ComponentResolveMetadata targetComponent;

    public LegacyConfigurationsSupplier(ComponentResolveMetadata targetComponent) {
        this.targetComponent = targetComponent;
    }

    public ImmutableList<? extends ConfigurationMetadata> get() {
        Set<String> configurationNames = this.targetComponent.getConfigurationNames();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String configurationName : configurationNames) {
            ConfigurationMetadata configuration = this.targetComponent.getConfiguration(configurationName);
            if (!configuration.isCanBeConsumed()) continue;
            builder.add((Object)configuration);
        }
        return builder.build();
    }
}

