/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.transforms.implementations.FuncHere;
import com.sun.org.apache.xml.internal.security.utils.XPathAPI;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.compiler.FunctionTable;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XalanXPathAPI
implements XPathAPI {
    private static final Logger LOG = LoggerFactory.getLogger(XalanXPathAPI.class);
    private String xpathStr;
    private XPath xpath;
    private static FunctionTable funcTable;
    private static boolean installed;
    private XPathContext context;

    @Override
    public NodeList selectNodeList(Node node, Node node2, String string, Node node3) throws TransformerException {
        XObject xObject = this.eval(node, node2, string, node3);
        return xObject.nodelist();
    }

    @Override
    public boolean evaluate(Node node, Node node2, String string, Node node3) throws TransformerException {
        XObject xObject = this.eval(node, node2, string, node3);
        return xObject.bool();
    }

    @Override
    public void clear() {
        this.xpathStr = null;
        this.xpath = null;
        this.context = null;
    }

    public static synchronized boolean isInstalled() {
        return installed;
    }

    private XObject eval(Node node, Node node2, String string, Node node3) throws TransformerException {
        if (this.context == null) {
            this.context = new XPathContext(node2);
            this.context.setSecureProcessing(true);
        }
        Node node4 = node3.getNodeType() == 9 ? ((Document)node3).getDocumentElement() : node3;
        PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault(node4);
        if (!string.equals(this.xpathStr)) {
            if (string.indexOf("here()") > 0) {
                this.context.reset();
            }
            this.xpath = this.createXPath(string, prefixResolverDefault);
            this.xpathStr = string;
        }
        int n = this.context.getDTMHandleFromNode(node);
        return this.xpath.execute(this.context, n, (PrefixResolver)prefixResolverDefault);
    }

    private XPath createXPath(String string, PrefixResolver prefixResolver) throws TransformerException {
        XPath xPath = null;
        Class[] classArray = new Class[]{String.class, SourceLocator.class, PrefixResolver.class, Integer.TYPE, ErrorListener.class, FunctionTable.class};
        Object[] objectArray = new Object[]{string, null, prefixResolver, 0, null, funcTable};
        try {
            Constructor constructor = XPath.class.getConstructor(classArray);
            xPath = (XPath)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            LOG.debug(exception.getMessage(), exception);
        }
        if (xPath == null) {
            xPath = new XPath(string, null, prefixResolver, 0, null);
        }
        return xPath;
    }

    private static synchronized void fixupFunctionTable() {
        Object[] objectArray;
        Method method;
        Class[] classArray;
        installed = false;
        LOG.debug("Registering Here function");
        try {
            classArray = new Class[]{String.class, Expression.class};
            method = FunctionTable.class.getMethod("installFunction", classArray);
            if ((method.getModifiers() & 8) != 0) {
                objectArray = new Object[]{"here", new FuncHere()};
                method.invoke(null, objectArray);
                installed = true;
            }
        }
        catch (Exception exception) {
            LOG.debug("Error installing function using the static installFunction method", exception);
        }
        if (!installed) {
            try {
                funcTable = new FunctionTable();
                classArray = new Class[]{String.class, Class.class};
                method = FunctionTable.class.getMethod("installFunction", classArray);
                objectArray = new Object[]{"here", FuncHere.class};
                method.invoke(funcTable, objectArray);
                installed = true;
            }
            catch (Exception exception) {
                LOG.debug("Error installing function using the static installFunction method", exception);
            }
        }
        if (installed) {
            LOG.debug("Registered class {} for XPath function 'here()' function in internal table", FuncHere.class.getName());
        } else {
            LOG.debug("Unable to register class {} for XPath function 'here()' function in internal table", FuncHere.class.getName());
        }
    }

    static {
        XalanXPathAPI.fixupFunctionTable();
    }
}

