# 
#  Copyright (c) 1994-1998 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: svrStatus.t,v 1.1.1.1 1998/01/04 22:47:29 abm Exp $
#

#
# Make a window for user to view/remove fax queue entry.
#


proc svrStatus { top } {

    set t [mkToplevel $top {Fax Status Display}] 
    wm geometry $t 600x200
    set q [mkFrame $t q]
    set oper [mkFrame $t oper {-side bottom -fill x}] 
    set lb [mkListbox $q -font fixed -selectmode browse]
    mkButton $oper rescan {-side left} -text Update -command "updateStatus $lb"
    mkButton $oper remove {-side left} -text Remove -command "removeJob $lb"
    mkButton $oper dismiss {-side left} -text Dismiss -command "destroy $t"

    updateStatus $lb
}

proc updateStatus { lb } {

    # Remove whats already in the listbox
    $lb delete 0 end

    if {![catch {exec faxstat -s} res]} {
	set items [split $res "\n"]
	foreach i $items {
	    $lb insert end $i
	}
    } else {
	tk_dialog .err "Ooops!" "$res" questhead 0 OK
    }
}

proc removeJob { lb } {

    set idx [$lb curselection]
    if {$idx == ""} {
	return
    }
    set entry [$lb get $idx]

    # Get the job number
    if {[regexp {^[0-9]+} $entry job]} {
	catch {exec faxrm $job} res
	# Delete entry
	$lb delete $idx
	tk_dialog .err "Queue Entry Status" "$res" info 0 OK
    }
    # Remove highlight
    $lb select clear $idx 
}
