/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.velocity.tools.generic.ValueParser;

public class ResourceTool {
    public static final String BUNDLES_KEY = "bundles";
    public static final String LOCALE_KEY = "locale";
    private String[] bundles = new String[]{"resources"};
    private Locale locale = Locale.getDefault();

    protected final void setDefaultBundle(String bundle) {
        if (bundle == null) {
            throw new NullPointerException("Default bundle cannot be null");
        }
        this.bundles = new String[]{bundle};
    }

    protected final String getDefaultBundle() {
        return this.bundles[0];
    }

    protected final void setDefaultLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Default locale cannot be null");
        }
        this.locale = locale;
    }

    protected final Locale getDefaultLocale() {
        return this.locale;
    }

    public void configure(Map params) {
        Locale locale;
        ValueParser parser = new ValueParser(params);
        String[] bundles = parser.getStrings(BUNDLES_KEY);
        if (bundles != null) {
            this.bundles = bundles;
        }
        if ((locale = parser.getLocale(LOCALE_KEY)) != null) {
            this.locale = locale;
        }
    }

    public Key get(String key) {
        return new Key(key, this.bundles, this.locale, null);
    }

    public Key bundle(String bundle) {
        return new Key(null, new String[]{bundle}, this.locale, null);
    }

    public Key locale(Locale locale) {
        return new Key(null, this.bundles, locale, null);
    }

    public Key insert(Object[] args) {
        return new Key(null, this.bundles, this.locale, args);
    }

    public Key insert(List args) {
        return this.insert(args.toArray());
    }

    public Key insert(Object arg) {
        return this.insert(new Object[]{arg});
    }

    public Key insert(Object arg0, Object arg1) {
        return this.insert(new Object[]{arg0, arg1});
    }

    public Object get(String key, String baseName, Locale locale) {
        ResourceBundle bundle;
        if (baseName == null || key == null) {
            return null;
        }
        if (locale == null) {
            locale = this.locale;
        }
        if ((bundle = ResourceBundle.getBundle(baseName, locale)) != null) {
            try {
                return bundle.getObject(key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public Object get(String key, String[] bundles, Locale locale) {
        for (int i = 0; i < bundles.length; ++i) {
            Object resource = this.get(key, bundles[i], locale);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    public String render(Object resource, Object[] args) {
        String value = String.valueOf(resource);
        if (args == null) {
            return value;
        }
        return MessageFormat.format(value, args);
    }

    public final class Key {
        private String[] bundles;
        private String key;
        private Locale locale;
        private Object[] args;
        private boolean cached = false;
        private Object rawValue;

        public Key(String key, String[] bundles, Locale locale, Object[] args) {
            this.key = key;
            this.bundles = bundles;
            this.locale = locale;
            this.args = args;
        }

        public Key get(String key) {
            String newKey = this.key == null ? key : this.key + '.' + key;
            return new Key(newKey, this.bundles, this.locale, this.args);
        }

        public Key bundle(String bundle) {
            String[] newBundles = new String[]{bundle};
            return new Key(this.key, newBundles, this.locale, this.args);
        }

        public Key locale(Locale locale) {
            return new Key(this.key, this.bundles, locale, this.args);
        }

        public Key insert(Object[] args) {
            Object[] newargs;
            if (this.args == null) {
                newargs = args;
            } else {
                newargs = new Object[this.args.length + args.length];
                System.arraycopy(this.args, 0, newargs, 0, this.args.length);
                System.arraycopy(args, 0, newargs, this.args.length, args.length);
            }
            return new Key(this.key, this.bundles, this.locale, newargs);
        }

        public Key insert(List args) {
            return this.insert(args.toArray());
        }

        public Key insert(Object arg) {
            return this.insert(new Object[]{arg});
        }

        public Key insert(Object arg0, Object arg1) {
            return this.insert(new Object[]{arg0, arg1});
        }

        public boolean getExists() {
            return this.getRaw() != null;
        }

        public Object getRaw() {
            if (!this.cached) {
                this.rawValue = ResourceTool.this.get(this.key, this.bundles, this.locale);
                this.cached = true;
            }
            return this.rawValue;
        }

        public String toString() {
            if (this.key == null) {
                return "";
            }
            if (!this.getExists()) {
                return "???" + this.key + "???";
            }
            return ResourceTool.this.render(this.rawValue, this.args);
        }
    }
}

