/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class SetDestinationMessage
extends DOMMessage {
    private final String unitId;
    private final String destinationId;

    public SetDestinationMessage(Unit unit, Location destination) {
        super(SetDestinationMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.destinationId = destination == null ? null : destination.getId();
    }

    public SetDestinationMessage(Game game, Element element) {
        super(SetDestinationMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.destinationId = element.hasAttribute("destination") ? element.getAttribute("destination") : null;
    }

    public Element handle(FreeColServer server, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Game game = serverPlayer.getGame();
        try {
            unit = serverPlayer.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Location destination = this.destinationId == null ? null : game.findFreeColLocation(this.destinationId);
        return server.getInGameController().setDestination(serverPlayer, unit, destination);
    }

    @Override
    public Element toXMLElement() {
        Element result = SetDestinationMessage.createMessage(SetDestinationMessage.getXMLElementTagName(), "unit", this.unitId);
        if (this.destinationId != null) {
            result.setAttribute("destination", this.destinationId);
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "setDestination";
    }
}

