/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.BaseForkOptionsConverter;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.compile.GroovyForkOptions;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.jvm.GroovyJpmsWorkarounds;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.HierarchicalClassLoaderStructure;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerFactory;

public class DaemonGroovyCompiler
extends AbstractDaemonCompiler<GroovyJavaJointCompileSpec> {
    private final Class<? extends Compiler<GroovyJavaJointCompileSpec>> compilerClass;
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("groovy", "org.codehaus.groovy", "groovyjarjarantlr", "groovyjarjarasm", "groovyjarjarcommonscli", "org.apache.tools.ant", "com.sun.tools.javac");
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final File daemonWorkingDir;
    private final JvmVersionDetector jvmVersionDetector;

    public DaemonGroovyCompiler(File daemonWorkingDir, Class<? extends Compiler<GroovyJavaJointCompileSpec>> compilerClass, ClassPathRegistry classPathRegistry, WorkerFactory workerFactory, ClassLoaderRegistry classLoaderRegistry, JavaForkOptionsFactory forkOptionsFactory, JvmVersionDetector jvmVersionDetector, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        super(workerFactory, actionExecutionSpecFactory);
        this.compilerClass = compilerClass;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
        this.forkOptionsFactory = forkOptionsFactory;
        this.daemonWorkingDir = daemonWorkingDir;
        this.jvmVersionDetector = jvmVersionDetector;
    }

    protected AbstractDaemonCompiler.CompilerParameters getCompilerParameters(GroovyJavaJointCompileSpec spec) {
        return new GroovyCompilerParameters(this.compilerClass.getName(), new Object[]{this.classPathRegistry.getClassPath("JAVA-COMPILER-PLUGIN").getAsFiles()}, spec);
    }

    protected DaemonForkOptions toDaemonForkOptions(GroovyJavaJointCompileSpec spec) {
        ForkOptions javaOptions = spec.getCompileOptions().getForkOptions();
        GroovyForkOptions groovyOptions = spec.getGroovyCompileOptions().getForkOptions();
        List antFiles = this.classPathRegistry.getClassPath("ANT").getAsFiles();
        Iterable classpath = Iterables.concat((Iterable)spec.getGroovyClasspath(), (Iterable)antFiles);
        VisitableURLClassLoader.Spec targetGroovyClasspath = new VisitableURLClassLoader.Spec("worker-loader", DefaultClassPath.of((Iterable)classpath).getAsURLs());
        List languageGroovyFiles = this.classPathRegistry.getClassPath("GROOVY-COMPILER").getAsFiles();
        VisitableURLClassLoader.Spec compilerClasspath = new VisitableURLClassLoader.Spec("compiler-loader", DefaultClassPath.of((Collection)languageGroovyFiles).getAsURLs());
        FilteringClassLoader.Spec gradleAndUserFilter = DaemonGroovyCompiler.getMinimalGradleFilter();
        for (String sharedPackage : SHARED_PACKAGES) {
            gradleAndUserFilter.allowPackage(sharedPackage);
        }
        HierarchicalClassLoaderStructure classLoaderStructure = new HierarchicalClassLoaderStructure((ClassLoaderSpec)this.classLoaderRegistry.getGradleWorkerExtensionSpec()).withChild((ClassLoaderSpec)DaemonGroovyCompiler.getMinimalGradleFilter()).withChild((ClassLoaderSpec)targetGroovyClasspath).withChild((ClassLoaderSpec)gradleAndUserFilter).withChild((ClassLoaderSpec)compilerClasspath);
        JavaForkOptions javaForkOptions = new BaseForkOptionsConverter(this.forkOptionsFactory).transform(this.mergeForkOptions((BaseForkOptions)javaOptions, groovyOptions));
        javaForkOptions.setWorkingDir(this.daemonWorkingDir);
        javaForkOptions.setExecutable(javaOptions.getExecutable());
        if (this.jvmVersionDetector.getJavaVersion(javaForkOptions.getExecutable()).isJava9Compatible()) {
            javaForkOptions.jvmArgs((Iterable)GroovyJpmsWorkarounds.SUPPRESS_COMMON_GROOVY_WARNINGS);
        }
        return new DaemonForkOptionsBuilder(this.forkOptionsFactory).javaForkOptions(javaForkOptions).keepAliveMode(KeepAliveMode.SESSION).withClassLoaderStructure((ClassLoaderStructure)classLoaderStructure).build();
    }

    private static FilteringClassLoader.Spec getMinimalGradleFilter() {
        FilteringClassLoader.Spec gradleFilterSpec = new FilteringClassLoader.Spec();
        gradleFilterSpec.allowPackage("org.slf4j");
        gradleFilterSpec.allowPackage("net.rubygrapefruit.platform");
        gradleFilterSpec.allowPackage("javax.inject");
        gradleFilterSpec.allowPackage("org.gradle");
        gradleFilterSpec.allowPackage("com.google");
        gradleFilterSpec.disallowPackage("org.gradle.api.internal.tasks.compile");
        return gradleFilterSpec;
    }

    public static class GroovyCompilerParameters
    extends AbstractDaemonCompiler.CompilerParameters {
        private final GroovyJavaJointCompileSpec compileSpec;

        public GroovyCompilerParameters(String compilerClassName, Object[] compilerInstanceParameters, GroovyJavaJointCompileSpec compileSpec) {
            super(compilerClassName, compilerInstanceParameters);
            this.compileSpec = compileSpec;
        }

        public GroovyJavaJointCompileSpec getCompileSpec() {
            return this.compileSpec;
        }
    }
}

