/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.openid;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.openid.conf.ConfigurationService;
import org.apache.guacamole.auth.openid.token.NonceService;
import org.apache.guacamole.auth.openid.token.TokenValidationService;
import org.apache.guacamole.auth.sso.SSOAuthenticationProviderService;
import org.apache.guacamole.auth.sso.user.SSOAuthenticatedUser;
import org.apache.guacamole.form.RedirectField;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;
import org.jose4j.jwt.JwtClaims;

@Singleton
public class AuthenticationProviderService
implements SSOAuthenticationProviderService {
    public static final String TOKEN_PARAMETER_NAME = "id_token";
    @Inject
    private ConfigurationService confService;
    @Inject
    private NonceService nonceService;
    @Inject
    private TokenValidationService tokenService;
    @Inject
    private Provider<SSOAuthenticatedUser> authenticatedUserProvider;

    @Override
    public SSOAuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        JwtClaims claims;
        String token;
        String username = null;
        Set<String> groups = null;
        HttpServletRequest request = credentials.getRequest();
        if (request != null && (token = request.getParameter(TOKEN_PARAMETER_NAME)) != null && (claims = this.tokenService.validateToken(token)) != null) {
            username = this.tokenService.processUsername(claims);
            groups = this.tokenService.processGroups(claims);
        }
        if (username != null) {
            SSOAuthenticatedUser authenticatedUser = this.authenticatedUserProvider.get();
            authenticatedUser.init(username, credentials, groups, Collections.emptyMap());
            return authenticatedUser;
        }
        throw new GuacamoleInvalidCredentialsException("Invalid login.", new CredentialsInfo(Arrays.asList(new RedirectField(TOKEN_PARAMETER_NAME, this.getLoginURI(), new TranslatableMessage("LOGIN.INFO_IDP_REDIRECT_PENDING")))));
    }

    @Override
    public URI getLoginURI() throws GuacamoleException {
        return UriBuilder.fromUri((URI)this.confService.getAuthorizationEndpoint()).queryParam("scope", new Object[]{this.confService.getScope()}).queryParam("response_type", new Object[]{TOKEN_PARAMETER_NAME}).queryParam("client_id", new Object[]{this.confService.getClientID()}).queryParam("redirect_uri", new Object[]{this.confService.getRedirectURI()}).queryParam("nonce", new Object[]{this.nonceService.generate((long)this.confService.getMaxNonceValidity() * 60000L)}).build(new Object[0]);
    }

    @Override
    public void shutdown() {
    }
}

