/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.tinyexr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.util.tinyexr.DeepImage;
import org.lwjgl.util.tinyexr.EXRHeader;
import org.lwjgl.util.tinyexr.EXRImage;
import org.lwjgl.util.tinyexr.EXRVersion;

public class TinyEXR {
    public static final int TINYEXR_SUCCESS = 0;
    public static final int TINYEXR_ERROR_INVALID_MAGIC_NUMBER = -1;
    public static final int TINYEXR_ERROR_INVALID_EXR_VERSION = -2;
    public static final int TINYEXR_ERROR_INVALID_ARGUMENT = -3;
    public static final int TINYEXR_ERROR_INVALID_DATA = -4;
    public static final int TINYEXR_ERROR_INVALID_FILE = -5;
    public static final int TINYEXR_ERROR_INVALID_PARAMETER = -6;
    public static final int TINYEXR_ERROR_CANT_OPEN_FILE = -7;
    public static final int TINYEXR_ERROR_UNSUPPORTED_FORMAT = -8;
    public static final int TINYEXR_ERROR_INVALID_HEADER = -9;
    public static final int TINYEXR_ERROR_UNSUPPORTED_FEATURE = -10;
    public static final int TINYEXR_ERROR_CANT_WRITE_FILE = -11;
    public static final int TINYEXR_ERROR_SERIALZATION_FAILED = -12;
    public static final int TINYEXR_ERROR_LAYER_NOT_FOUND = -13;
    public static final int TINYEXR_PIXELTYPE_UINT = 0;
    public static final int TINYEXR_PIXELTYPE_HALF = 1;
    public static final int TINYEXR_PIXELTYPE_FLOAT = 2;
    public static final int TINYEXR_MAX_HEADER_ATTRIBUTES = 1024;
    public static final int TINYEXR_MAX_CUSTOM_ATTRIBUTES = 128;
    public static final int TINYEXR_COMPRESSIONTYPE_NONE = 0;
    public static final int TINYEXR_COMPRESSIONTYPE_RLE = 1;
    public static final int TINYEXR_COMPRESSIONTYPE_ZIPS = 2;
    public static final int TINYEXR_COMPRESSIONTYPE_ZIP = 3;
    public static final int TINYEXR_COMPRESSIONTYPE_PIZ = 4;
    public static final int TINYEXR_COMPRESSIONTYPE_ZFP = 128;
    public static final int TINYEXR_ZFP_COMPRESSIONTYPE_RATE = 0;
    public static final int TINYEXR_ZFP_COMPRESSIONTYPE_PRECISION = 1;
    public static final int TINYEXR_ZFP_COMPRESSIONTYPE_ACCURACY = 2;
    public static final int TINYEXR_TILE_ONE_LEVEL = 0;
    public static final int TINYEXR_TILE_MIPMAP_LEVELS = 1;
    public static final int TINYEXR_TILE_RIPMAP_LEVELS = 2;
    public static final int TINYEXR_TILE_ROUND_DOWN = 0;
    public static final int TINYEXR_TILE_ROUND_UP = 1;

    protected TinyEXR() {
        throw new UnsupportedOperationException();
    }

    public static native int nLoadEXRWithLayer(long var0, long var2, long var4, long var6, long var8, long var10);

    public static int LoadEXRWithLayer(@NativeType(value="float **") PointerBuffer out_rgba, @NativeType(value="int *") IntBuffer width, @NativeType(value="int *") IntBuffer height, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const *") ByteBuffer layer_name, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)out_rgba, (int)1);
            Checks.check((Buffer)width, (int)1);
            Checks.check((Buffer)height, (int)1);
            Checks.checkNT1((ByteBuffer)filename);
            Checks.checkNT1((ByteBuffer)layer_name);
            Checks.check((CustomBuffer)err, (int)1);
        }
        return TinyEXR.nLoadEXRWithLayer(MemoryUtil.memAddress((CustomBuffer)out_rgba), MemoryUtil.memAddress((IntBuffer)width), MemoryUtil.memAddress((IntBuffer)height), MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((ByteBuffer)layer_name), MemoryUtil.memAddress((CustomBuffer)err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int LoadEXRWithLayer(@NativeType(value="float **") PointerBuffer out_rgba, @NativeType(value="int *") IntBuffer width, @NativeType(value="int *") IntBuffer height, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const *") CharSequence layer_name, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)out_rgba, (int)1);
            Checks.check((Buffer)width, (int)1);
            Checks.check((Buffer)height, (int)1);
            Checks.check((CustomBuffer)err, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            stack.nASCII(layer_name, true);
            long layer_nameEncoded = stack.getPointerAddress();
            int n = TinyEXR.nLoadEXRWithLayer(MemoryUtil.memAddress((CustomBuffer)out_rgba), MemoryUtil.memAddress((IntBuffer)width), MemoryUtil.memAddress((IntBuffer)height), filenameEncoded, layer_nameEncoded, MemoryUtil.memAddress((CustomBuffer)err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nEXRLayers(long var0, long var2, long var4, long var6);

    public static int EXRLayers(@NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const ***") PointerBuffer layer_names, @NativeType(value="int *") IntBuffer num_layers, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((CustomBuffer)layer_names, (int)1);
            Checks.check((Buffer)num_layers, (int)1);
            Checks.check((CustomBuffer)err, (int)1);
        }
        return TinyEXR.nEXRLayers(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((CustomBuffer)layer_names), MemoryUtil.memAddress((IntBuffer)num_layers), MemoryUtil.memAddress((CustomBuffer)err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int EXRLayers(@NativeType(value="char const *") CharSequence filename, @NativeType(value="char const ***") PointerBuffer layer_names, @NativeType(value="int *") IntBuffer num_layers, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)layer_names, (int)1);
            Checks.check((Buffer)num_layers, (int)1);
            Checks.check((CustomBuffer)err, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = TinyEXR.nEXRLayers(filenameEncoded, MemoryUtil.memAddress((CustomBuffer)layer_names), MemoryUtil.memAddress((IntBuffer)num_layers), MemoryUtil.memAddress((CustomBuffer)err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nInitEXRHeader(long var0);

    public static void InitEXRHeader(@NativeType(value="EXRHeader *") EXRHeader exr_header) {
        TinyEXR.nInitEXRHeader(exr_header.address());
    }

    public static native void nInitEXRImage(long var0);

    public static void InitEXRImage(@NativeType(value="EXRImage *") EXRImage exr_image) {
        TinyEXR.nInitEXRImage(exr_image.address());
    }

    public static native int nFreeEXRHeader(long var0);

    public static int FreeEXRHeader(@NativeType(value="EXRHeader *") EXRHeader exr_header) {
        return TinyEXR.nFreeEXRHeader(exr_header.address());
    }

    public static native int nFreeEXRImage(long var0);

    public static int FreeEXRImage(@NativeType(value="EXRImage *") EXRImage exr_image) {
        return TinyEXR.nFreeEXRImage(exr_image.address());
    }

    public static native void nFreeEXRErrorMessage(long var0);

    public static void FreeEXRErrorMessage(@NativeType(value="char const *") ByteBuffer msg) {
        TinyEXR.nFreeEXRErrorMessage(MemoryUtil.memAddress((ByteBuffer)msg));
    }

    public static native int nParseEXRVersionFromFile(long var0, long var2);

    public static int ParseEXRVersionFromFile(@NativeType(value="EXRVersion *") EXRVersion version, @NativeType(value="char const *") ByteBuffer filename) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
        }
        return TinyEXR.nParseEXRVersionFromFile(version.address(), MemoryUtil.memAddress((ByteBuffer)filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ParseEXRVersionFromFile(@NativeType(value="EXRVersion *") EXRVersion version, @NativeType(value="char const *") CharSequence filename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = TinyEXR.nParseEXRVersionFromFile(version.address(), filenameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nParseEXRVersionFromMemory(long var0, long var2, long var4);

    public static int ParseEXRVersionFromMemory(@NativeType(value="EXRVersion *") EXRVersion version, @NativeType(value="unsigned char const *") ByteBuffer memory) {
        return TinyEXR.nParseEXRVersionFromMemory(version.address(), MemoryUtil.memAddress((ByteBuffer)memory), memory.remaining());
    }

    public static native int nParseEXRHeaderFromFile(long var0, long var2, long var4, long var6);

    public static int ParseEXRHeaderFromFile(@NativeType(value="EXRHeader *") EXRHeader header, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((CustomBuffer)err, (int)1);
        }
        return TinyEXR.nParseEXRHeaderFromFile(header.address(), version.address(), MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((CustomBuffer)err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ParseEXRHeaderFromFile(@NativeType(value="EXRHeader *") EXRHeader header, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)err, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = TinyEXR.nParseEXRHeaderFromFile(header.address(), version.address(), filenameEncoded, MemoryUtil.memAddress((CustomBuffer)err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nParseEXRHeaderFromMemory(long var0, long var2, long var4, long var6, long var8);

    public static int ParseEXRHeaderFromMemory(@NativeType(value="EXRHeader *") EXRHeader header, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="unsigned char const *") ByteBuffer memory, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)err, (int)1);
        }
        return TinyEXR.nParseEXRHeaderFromMemory(header.address(), version.address(), MemoryUtil.memAddress((ByteBuffer)memory), memory.remaining(), MemoryUtil.memAddress((CustomBuffer)err));
    }

    public static native int nParseEXRMultipartHeaderFromFile(long var0, long var2, long var4, long var6, long var8);

    public static int ParseEXRMultipartHeaderFromFile(@NativeType(value="EXRHeader ***") PointerBuffer headers, @NativeType(value="int *") IntBuffer num_headers, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)headers, (int)1);
            Checks.check((Buffer)num_headers, (int)1);
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((CustomBuffer)err, (int)1);
        }
        return TinyEXR.nParseEXRMultipartHeaderFromFile(MemoryUtil.memAddress((CustomBuffer)headers), MemoryUtil.memAddress((IntBuffer)num_headers), version.address(), MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((CustomBuffer)err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int ParseEXRMultipartHeaderFromFile(@NativeType(value="EXRHeader ***") PointerBuffer headers, @NativeType(value="int *") IntBuffer num_headers, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)headers, (int)1);
            Checks.check((Buffer)num_headers, (int)1);
            Checks.check((CustomBuffer)err, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = TinyEXR.nParseEXRMultipartHeaderFromFile(MemoryUtil.memAddress((CustomBuffer)headers), MemoryUtil.memAddress((IntBuffer)num_headers), version.address(), filenameEncoded, MemoryUtil.memAddress((CustomBuffer)err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nParseEXRMultipartHeaderFromMemory(long var0, long var2, long var4, long var6, long var8, long var10);

    public static int ParseEXRMultipartHeaderFromMemory(@NativeType(value="EXRHeader ***") PointerBuffer headers, @NativeType(value="int *") IntBuffer num_headers, @NativeType(value="EXRVersion const *") EXRVersion version, @NativeType(value="unsigned char const *") ByteBuffer memory, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)headers, (int)1);
            Checks.check((Buffer)num_headers, (int)1);
            Checks.check((CustomBuffer)err, (int)1);
        }
        return TinyEXR.nParseEXRMultipartHeaderFromMemory(MemoryUtil.memAddress((CustomBuffer)headers), MemoryUtil.memAddress((IntBuffer)num_headers), version.address(), MemoryUtil.memAddress((ByteBuffer)memory), memory.remaining(), MemoryUtil.memAddress((CustomBuffer)err));
    }

    public static native int nLoadEXRImageFromFile(long var0, long var2, long var4, long var6);

    public static int LoadEXRImageFromFile(@NativeType(value="EXRImage *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader header, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((CustomBuffer)err, (int)1);
            EXRHeader.validate(header.address());
        }
        return TinyEXR.nLoadEXRImageFromFile(image.address(), header.address(), MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((CustomBuffer)err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int LoadEXRImageFromFile(@NativeType(value="EXRImage *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader header, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)err, (int)1);
            EXRHeader.validate(header.address());
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = TinyEXR.nLoadEXRImageFromFile(image.address(), header.address(), filenameEncoded, MemoryUtil.memAddress((CustomBuffer)err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nLoadEXRImageFromMemory(long var0, long var2, long var4, long var6, long var8);

    public static int LoadEXRImageFromMemory(@NativeType(value="EXRImage *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader header, @NativeType(value="unsigned char const *") ByteBuffer memory, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)err, (int)1);
            EXRHeader.validate(header.address());
        }
        return TinyEXR.nLoadEXRImageFromMemory(image.address(), header.address(), MemoryUtil.memAddress((ByteBuffer)memory), memory.remaining(), MemoryUtil.memAddress((CustomBuffer)err));
    }

    public static native int nLoadEXRMultipartImageFromFile(long var0, long var2, int var4, long var5, long var7);

    public static int LoadEXRMultipartImageFromFile(@NativeType(value="EXRImage *") EXRImage.Buffer images, @NativeType(value="EXRHeader const **") PointerBuffer headers, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)headers, (int)images.remaining());
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((CustomBuffer)err, (int)1);
        }
        return TinyEXR.nLoadEXRMultipartImageFromFile(images.address(), MemoryUtil.memAddress((CustomBuffer)headers), images.remaining(), MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((CustomBuffer)err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int LoadEXRMultipartImageFromFile(@NativeType(value="EXRImage *") EXRImage.Buffer images, @NativeType(value="EXRHeader const **") PointerBuffer headers, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)headers, (int)images.remaining());
            Checks.check((CustomBuffer)err, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = TinyEXR.nLoadEXRMultipartImageFromFile(images.address(), MemoryUtil.memAddress((CustomBuffer)headers), images.remaining(), filenameEncoded, MemoryUtil.memAddress((CustomBuffer)err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nLoadEXRMultipartImageFromMemory(long var0, long var2, int var4, long var5, long var7, long var9);

    public static int LoadEXRMultipartImageFromMemory(@NativeType(value="EXRImage *") EXRImage.Buffer images, @NativeType(value="EXRHeader const **") PointerBuffer headers, @NativeType(value="unsigned char const *") ByteBuffer memory, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)headers, (int)images.remaining());
            Checks.check((CustomBuffer)err, (int)1);
        }
        return TinyEXR.nLoadEXRMultipartImageFromMemory(images.address(), MemoryUtil.memAddress((CustomBuffer)headers), images.remaining(), MemoryUtil.memAddress((ByteBuffer)memory), memory.remaining(), MemoryUtil.memAddress((CustomBuffer)err));
    }

    public static native int nSaveEXRImageToFile(long var0, long var2, long var4, long var6);

    public static int SaveEXRImageToFile(@NativeType(value="EXRImage const *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader exr_header, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((CustomBuffer)err, (int)1);
            EXRImage.validate(image.address());
            EXRHeader.validate(exr_header.address());
        }
        return TinyEXR.nSaveEXRImageToFile(image.address(), exr_header.address(), MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((CustomBuffer)err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int SaveEXRImageToFile(@NativeType(value="EXRImage const *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader exr_header, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)err, (int)1);
            EXRImage.validate(image.address());
            EXRHeader.validate(exr_header.address());
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = TinyEXR.nSaveEXRImageToFile(image.address(), exr_header.address(), filenameEncoded, MemoryUtil.memAddress((CustomBuffer)err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nSaveEXRImageToMemory(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long SaveEXRImageToMemory(@NativeType(value="EXRImage const *") EXRImage image, @NativeType(value="EXRHeader const *") EXRHeader exr_header, @NativeType(value="unsigned char **") PointerBuffer memory, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)memory, (int)1);
            Checks.check((CustomBuffer)err, (int)1);
            EXRImage.validate(image.address());
            EXRHeader.validate(exr_header.address());
        }
        return TinyEXR.nSaveEXRImageToMemory(image.address(), exr_header.address(), MemoryUtil.memAddress((CustomBuffer)memory), MemoryUtil.memAddress((CustomBuffer)err));
    }

    public static native int nLoadDeepEXR(long var0, long var2, long var4);

    public static int LoadDeepEXR(@NativeType(value="DeepImage *") DeepImage out_image, @NativeType(value="char const *") ByteBuffer filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((CustomBuffer)err, (int)1);
        }
        return TinyEXR.nLoadDeepEXR(out_image.address(), MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((CustomBuffer)err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int LoadDeepEXR(@NativeType(value="DeepImage *") DeepImage out_image, @NativeType(value="char const *") CharSequence filename, @NativeType(value="char const **") PointerBuffer err) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)err, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(filename, true);
            long filenameEncoded = stack.getPointerAddress();
            int n = TinyEXR.nLoadDeepEXR(out_image.address(), filenameEncoded, MemoryUtil.memAddress((CustomBuffer)err));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static {
        Library.loadSystem(System::load, System::loadLibrary, TinyEXR.class, (String)"org.lwjgl.tinyexr", (String)Platform.mapLibraryNameBundled((String)"lwjgl_tinyexr"));
    }
}

