/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkMacOSSurfaceCreateInfoMVK;

public class MVKMacosSurface {
    public static final int VK_MVK_MACOS_SURFACE_SPEC_VERSION = 2;
    public static final String VK_MVK_MACOS_SURFACE_EXTENSION_NAME = "VK_MVK_macos_surface";
    public static final int VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK = 1000123000;

    protected MVKMacosSurface() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsInstance(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_MVK_MACOS_SURFACE_EXTENSION_NAME) && VK.checkExtension(VK_MVK_MACOS_SURFACE_EXTENSION_NAME, VK.isSupported(provider, "vkCreateMacOSSurfaceMVK", caps));
    }

    public static int nvkCreateMacOSSurfaceMVK(VkInstance instance, long pCreateInfo, long pAllocator, long pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateMacOSSurfaceMVK;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkMacOSSurfaceCreateInfoMVK.validate(pCreateInfo);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        return JNI.callPPPPI((long)instance.address(), (long)pCreateInfo, (long)pAllocator, (long)pSurface, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateMacOSSurfaceMVK(VkInstance instance, @NativeType(value="VkMacOSSurfaceCreateInfoMVK const *") VkMacOSSurfaceCreateInfoMVK pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") LongBuffer pSurface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurface, (int)1);
        }
        return MVKMacosSurface.nvkCreateMacOSSurfaceMVK(instance, pCreateInfo.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pSurface));
    }

    @NativeType(value="VkResult")
    public static int vkCreateMacOSSurfaceMVK(VkInstance instance, @NativeType(value="VkMacOSSurfaceCreateInfoMVK const *") VkMacOSSurfaceCreateInfoMVK pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkSurfaceKHR *") long[] pSurface) {
        long __functionAddress = instance.getCapabilities().vkCreateMacOSSurfaceMVK;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pSurface, (int)1);
            VkMacOSSurfaceCreateInfoMVK.validate(pCreateInfo.address());
            if (pAllocator != null) {
                VkAllocationCallbacks.validate(pAllocator.address());
            }
        }
        return JNI.callPPPPI((long)instance.address(), (long)pCreateInfo.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pSurface, (long)__functionAddress);
    }
}

