/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMetalSurfaceCreateInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int PLAYER;

    public VkMetalSurfaceCreateInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMetalSurfaceCreateInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMetalSurfaceCreateInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMetalSurfaceCreateInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkMetalSurfaceCreateFlagsEXT")
    public int flags() {
        return VkMetalSurfaceCreateInfoEXT.nflags(this.address());
    }

    @NativeType(value="CAMetalLayer const *")
    public PointerBuffer pLayer(int capacity) {
        return VkMetalSurfaceCreateInfoEXT.npLayer(this.address(), capacity);
    }

    public VkMetalSurfaceCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMetalSurfaceCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkMetalSurfaceCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkMetalSurfaceCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkMetalSurfaceCreateInfoEXT flags(@NativeType(value="VkMetalSurfaceCreateFlagsEXT") int value) {
        VkMetalSurfaceCreateInfoEXT.nflags(this.address(), value);
        return this;
    }

    public VkMetalSurfaceCreateInfoEXT pLayer(@NativeType(value="CAMetalLayer const *") PointerBuffer value) {
        VkMetalSurfaceCreateInfoEXT.npLayer(this.address(), value);
        return this;
    }

    public VkMetalSurfaceCreateInfoEXT set(int sType, long pNext, int flags, PointerBuffer pLayer) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pLayer(pLayer);
        return this;
    }

    public VkMetalSurfaceCreateInfoEXT set(VkMetalSurfaceCreateInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMetalSurfaceCreateInfoEXT malloc() {
        return (VkMetalSurfaceCreateInfoEXT)VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkMetalSurfaceCreateInfoEXT calloc() {
        return (VkMetalSurfaceCreateInfoEXT)VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkMetalSurfaceCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkMetalSurfaceCreateInfoEXT)VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkMetalSurfaceCreateInfoEXT create(long address) {
        return (VkMetalSurfaceCreateInfoEXT)VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, (long)address);
    }

    @Nullable
    public static VkMetalSurfaceCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : (VkMetalSurfaceCreateInfoEXT)VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkMetalSurfaceCreateInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMetalSurfaceCreateInfoEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkMetalSurfaceCreateInfoEXT mallocStack() {
        return VkMetalSurfaceCreateInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkMetalSurfaceCreateInfoEXT callocStack() {
        return VkMetalSurfaceCreateInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkMetalSurfaceCreateInfoEXT mallocStack(MemoryStack stack) {
        return (VkMetalSurfaceCreateInfoEXT)VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMetalSurfaceCreateInfoEXT callocStack(MemoryStack stack) {
        return (VkMetalSurfaceCreateInfoEXT)VkMetalSurfaceCreateInfoEXT.wrap(VkMetalSurfaceCreateInfoEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMetalSurfaceCreateInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMetalSurfaceCreateInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMetalSurfaceCreateInfoEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static PointerBuffer npLayer(long struct, int capacity) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PLAYER)), (int)capacity);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npLayer(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PLAYER), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PLAYER)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkMetalSurfaceCreateInfoEXT.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkMetalSurfaceCreateInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkMetalSurfaceCreateInfoEXT.__member((int)4), VkMetalSurfaceCreateInfoEXT.__member((int)POINTER_SIZE), VkMetalSurfaceCreateInfoEXT.__member((int)4), VkMetalSurfaceCreateInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PLAYER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMetalSurfaceCreateInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMetalSurfaceCreateInfoEXT ELEMENT_FACTORY = VkMetalSurfaceCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMetalSurfaceCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMetalSurfaceCreateInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMetalSurfaceCreateInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkMetalSurfaceCreateFlagsEXT")
        public int flags() {
            return VkMetalSurfaceCreateInfoEXT.nflags(this.address());
        }

        @NativeType(value="CAMetalLayer const *")
        public PointerBuffer pLayer(int capacity) {
            return VkMetalSurfaceCreateInfoEXT.npLayer(this.address(), capacity);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMetalSurfaceCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMetalSurfaceCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkMetalSurfaceCreateFlagsEXT") int value) {
            VkMetalSurfaceCreateInfoEXT.nflags(this.address(), value);
            return this;
        }

        public Buffer pLayer(@NativeType(value="CAMetalLayer const *") PointerBuffer value) {
            VkMetalSurfaceCreateInfoEXT.npLayer(this.address(), value);
            return this;
        }
    }
}

