/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkSampleLocationEXT;

public class VkSampleLocationsInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SAMPLELOCATIONSPERPIXEL;
    public static final int SAMPLELOCATIONGRIDSIZE;
    public static final int SAMPLELOCATIONSCOUNT;
    public static final int PSAMPLELOCATIONS;

    public VkSampleLocationsInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSampleLocationsInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSampleLocationsInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSampleLocationsInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkSampleCountFlagBits")
    public int sampleLocationsPerPixel() {
        return VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address());
    }

    public VkExtent2D sampleLocationGridSize() {
        return VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int sampleLocationsCount() {
        return VkSampleLocationsInfoEXT.nsampleLocationsCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSampleLocationEXT const *")
    public VkSampleLocationEXT.Buffer pSampleLocations() {
        return VkSampleLocationsInfoEXT.npSampleLocations(this.address());
    }

    public VkSampleLocationsInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkSampleLocationsInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkSampleLocationsInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT sampleLocationsPerPixel(@NativeType(value="VkSampleCountFlagBits") int value) {
        VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT sampleLocationGridSize(VkExtent2D value) {
        VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT sampleLocationGridSize(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.sampleLocationGridSize());
        return this;
    }

    public VkSampleLocationsInfoEXT pSampleLocations(@Nullable @NativeType(value="VkSampleLocationEXT const *") VkSampleLocationEXT.Buffer value) {
        VkSampleLocationsInfoEXT.npSampleLocations(this.address(), value);
        return this;
    }

    public VkSampleLocationsInfoEXT set(int sType, long pNext, int sampleLocationsPerPixel, VkExtent2D sampleLocationGridSize, @Nullable VkSampleLocationEXT.Buffer pSampleLocations) {
        this.sType(sType);
        this.pNext(pNext);
        this.sampleLocationsPerPixel(sampleLocationsPerPixel);
        this.sampleLocationGridSize(sampleLocationGridSize);
        this.pSampleLocations(pSampleLocations);
        return this;
    }

    public VkSampleLocationsInfoEXT set(VkSampleLocationsInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSampleLocationsInfoEXT malloc() {
        return (VkSampleLocationsInfoEXT)VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSampleLocationsInfoEXT calloc() {
        return (VkSampleLocationsInfoEXT)VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSampleLocationsInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSampleLocationsInfoEXT)VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSampleLocationsInfoEXT create(long address) {
        return (VkSampleLocationsInfoEXT)VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, (long)address);
    }

    @Nullable
    public static VkSampleLocationsInfoEXT createSafe(long address) {
        return address == 0L ? null : (VkSampleLocationsInfoEXT)VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSampleLocationsInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSampleLocationsInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSampleLocationsInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSampleLocationsInfoEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSampleLocationsInfoEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSampleLocationsInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSampleLocationsInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSampleLocationsInfoEXT mallocStack() {
        return VkSampleLocationsInfoEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkSampleLocationsInfoEXT callocStack() {
        return VkSampleLocationsInfoEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkSampleLocationsInfoEXT mallocStack(MemoryStack stack) {
        return (VkSampleLocationsInfoEXT)VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSampleLocationsInfoEXT callocStack(MemoryStack stack) {
        return (VkSampleLocationsInfoEXT)VkSampleLocationsInfoEXT.wrap(VkSampleLocationsInfoEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSampleLocationsInfoEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSampleLocationsInfoEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSampleLocationsInfoEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSampleLocationsInfoEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nsampleLocationsPerPixel(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLELOCATIONSPERPIXEL);
    }

    public static VkExtent2D nsampleLocationGridSize(long struct) {
        return VkExtent2D.create(struct + (long)SAMPLELOCATIONGRIDSIZE);
    }

    public static int nsampleLocationsCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)SAMPLELOCATIONSCOUNT);
    }

    @Nullable
    public static VkSampleLocationEXT.Buffer npSampleLocations(long struct) {
        return VkSampleLocationEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSAMPLELOCATIONS)), VkSampleLocationsInfoEXT.nsampleLocationsCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsampleLocationsPerPixel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLELOCATIONSPERPIXEL, value);
    }

    public static void nsampleLocationGridSize(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SAMPLELOCATIONGRIDSIZE), (long)VkExtent2D.SIZEOF);
    }

    public static void nsampleLocationsCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SAMPLELOCATIONSCOUNT, value);
    }

    public static void npSampleLocations(long struct, @Nullable VkSampleLocationEXT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSAMPLELOCATIONS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkSampleLocationsInfoEXT.nsampleLocationsCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSampleLocationsInfoEXT.nsampleLocationsCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSAMPLELOCATIONS)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSampleLocationsInfoEXT.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkSampleLocationsInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkSampleLocationsInfoEXT.__member((int)4), VkSampleLocationsInfoEXT.__member((int)POINTER_SIZE), VkSampleLocationsInfoEXT.__member((int)4), VkSampleLocationsInfoEXT.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkSampleLocationsInfoEXT.__member((int)4), VkSampleLocationsInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SAMPLELOCATIONSPERPIXEL = layout.offsetof(2);
        SAMPLELOCATIONGRIDSIZE = layout.offsetof(3);
        SAMPLELOCATIONSCOUNT = layout.offsetof(4);
        PSAMPLELOCATIONS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkSampleLocationsInfoEXT, Buffer>
    implements NativeResource {
        private static final VkSampleLocationsInfoEXT ELEMENT_FACTORY = VkSampleLocationsInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSampleLocationsInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSampleLocationsInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSampleLocationsInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkSampleCountFlagBits")
        public int sampleLocationsPerPixel() {
            return VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address());
        }

        public VkExtent2D sampleLocationGridSize() {
            return VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int sampleLocationsCount() {
            return VkSampleLocationsInfoEXT.nsampleLocationsCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSampleLocationEXT const *")
        public VkSampleLocationEXT.Buffer pSampleLocations() {
            return VkSampleLocationsInfoEXT.npSampleLocations(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSampleLocationsInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSampleLocationsInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsPerPixel(@NativeType(value="VkSampleCountFlagBits") int value) {
            VkSampleLocationsInfoEXT.nsampleLocationsPerPixel(this.address(), value);
            return this;
        }

        public Buffer sampleLocationGridSize(VkExtent2D value) {
            VkSampleLocationsInfoEXT.nsampleLocationGridSize(this.address(), value);
            return this;
        }

        public Buffer sampleLocationGridSize(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.sampleLocationGridSize());
            return this;
        }

        public Buffer pSampleLocations(@Nullable @NativeType(value="VkSampleLocationEXT const *") VkSampleLocationEXT.Buffer value) {
            VkSampleLocationsInfoEXT.npSampleLocations(this.address(), value);
            return this;
        }
    }
}

