/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXCursor;
import org.lwjgl.llvm.CXIdxLoc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxAttrInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int CURSOR;
    public static final int LOC;

    public CXIdxAttrInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXIdxAttrInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxAttrKind")
    public int kind() {
        return CXIdxAttrInfo.nkind(this.address());
    }

    public CXCursor cursor() {
        return CXIdxAttrInfo.ncursor(this.address());
    }

    public CXIdxLoc loc() {
        return CXIdxAttrInfo.nloc(this.address());
    }

    public static CXIdxAttrInfo malloc() {
        return (CXIdxAttrInfo)CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXIdxAttrInfo calloc() {
        return (CXIdxAttrInfo)CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXIdxAttrInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXIdxAttrInfo)CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXIdxAttrInfo create(long address) {
        return (CXIdxAttrInfo)CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, (long)address);
    }

    @Nullable
    public static CXIdxAttrInfo createSafe(long address) {
        return address == 0L ? null : (CXIdxAttrInfo)CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXIdxAttrInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXIdxAttrInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXIdxAttrInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXIdxAttrInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXIdxAttrInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXIdxAttrInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXIdxAttrInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXIdxAttrInfo mallocStack() {
        return CXIdxAttrInfo.mallocStack(MemoryStack.stackGet());
    }

    public static CXIdxAttrInfo callocStack() {
        return CXIdxAttrInfo.callocStack(MemoryStack.stackGet());
    }

    public static CXIdxAttrInfo mallocStack(MemoryStack stack) {
        return (CXIdxAttrInfo)CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXIdxAttrInfo callocStack(MemoryStack stack) {
        return (CXIdxAttrInfo)CXIdxAttrInfo.wrap(CXIdxAttrInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXIdxAttrInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXIdxAttrInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXIdxAttrInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXIdxAttrInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nkind(long struct) {
        return UNSAFE.getInt(null, struct + (long)KIND);
    }

    public static CXCursor ncursor(long struct) {
        return CXCursor.create(struct + (long)CURSOR);
    }

    public static CXIdxLoc nloc(long struct) {
        return CXIdxLoc.create(struct + (long)LOC);
    }

    static {
        Struct.Layout layout = CXIdxAttrInfo.__struct((Struct.Member[])new Struct.Member[]{CXIdxAttrInfo.__member((int)4), CXIdxAttrInfo.__member((int)CXCursor.SIZEOF, (int)CXCursor.ALIGNOF), CXIdxAttrInfo.__member((int)CXIdxLoc.SIZEOF, (int)CXIdxLoc.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        CURSOR = layout.offsetof(1);
        LOC = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXIdxAttrInfo, Buffer>
    implements NativeResource {
        private static final CXIdxAttrInfo ELEMENT_FACTORY = CXIdxAttrInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXIdxAttrInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxAttrKind")
        public int kind() {
            return CXIdxAttrInfo.nkind(this.address());
        }

        public CXCursor cursor() {
            return CXIdxAttrInfo.ncursor(this.address());
        }

        public CXIdxLoc loc() {
            return CXIdxAttrInfo.nloc(this.address());
        }
    }
}

