/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXSourceRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR_DATA;
    public static final int BEGIN_INT_DATA;
    public static final int END_INT_DATA;

    public CXSourceRange(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXSourceRange.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *[2]")
    public PointerBuffer ptr_data() {
        return CXSourceRange.nptr_data(this.address());
    }

    @NativeType(value="void const *")
    public long ptr_data(int index) {
        return CXSourceRange.nptr_data(this.address(), index);
    }

    @NativeType(value="unsigned")
    public int begin_int_data() {
        return CXSourceRange.nbegin_int_data(this.address());
    }

    @NativeType(value="unsigned")
    public int end_int_data() {
        return CXSourceRange.nend_int_data(this.address());
    }

    public static CXSourceRange malloc() {
        return (CXSourceRange)CXSourceRange.wrap(CXSourceRange.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXSourceRange calloc() {
        return (CXSourceRange)CXSourceRange.wrap(CXSourceRange.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXSourceRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXSourceRange)CXSourceRange.wrap(CXSourceRange.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXSourceRange create(long address) {
        return (CXSourceRange)CXSourceRange.wrap(CXSourceRange.class, (long)address);
    }

    @Nullable
    public static CXSourceRange createSafe(long address) {
        return address == 0L ? null : (CXSourceRange)CXSourceRange.wrap(CXSourceRange.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXSourceRange.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXSourceRange.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXSourceRange.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXSourceRange.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXSourceRange.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXSourceRange.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXSourceRange.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXSourceRange mallocStack() {
        return CXSourceRange.mallocStack(MemoryStack.stackGet());
    }

    public static CXSourceRange callocStack() {
        return CXSourceRange.callocStack(MemoryStack.stackGet());
    }

    public static CXSourceRange mallocStack(MemoryStack stack) {
        return (CXSourceRange)CXSourceRange.wrap(CXSourceRange.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXSourceRange callocStack(MemoryStack stack) {
        return (CXSourceRange)CXSourceRange.wrap(CXSourceRange.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CXSourceRange.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CXSourceRange.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXSourceRange.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)CXSourceRange.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static PointerBuffer nptr_data(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)PTR_DATA), (int)2);
    }

    public static long nptr_data(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PTR_DATA + Checks.check((int)index, (int)2) * (long)POINTER_SIZE));
    }

    public static int nbegin_int_data(long struct) {
        return UNSAFE.getInt(null, struct + (long)BEGIN_INT_DATA);
    }

    public static int nend_int_data(long struct) {
        return UNSAFE.getInt(null, struct + (long)END_INT_DATA);
    }

    static {
        Struct.Layout layout = CXSourceRange.__struct((Struct.Member[])new Struct.Member[]{CXSourceRange.__array((int)POINTER_SIZE, (int)2), CXSourceRange.__member((int)4), CXSourceRange.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR_DATA = layout.offsetof(0);
        BEGIN_INT_DATA = layout.offsetof(1);
        END_INT_DATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXSourceRange, Buffer>
    implements NativeResource {
        private static final CXSourceRange ELEMENT_FACTORY = CXSourceRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXSourceRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *[2]")
        public PointerBuffer ptr_data() {
            return CXSourceRange.nptr_data(this.address());
        }

        @NativeType(value="void const *")
        public long ptr_data(int index) {
            return CXSourceRange.nptr_data(this.address(), index);
        }

        @NativeType(value="unsigned")
        public int begin_int_data() {
            return CXSourceRange.nbegin_int_data(this.address());
        }

        @NativeType(value="unsigned")
        public int end_int_data() {
            return CXSourceRange.nend_int_data(this.address());
        }
    }
}

