/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL20;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class CL21
extends CL20 {
    public static final int CL_VERSION_2_1 = 1;
    public static final int CL_PLATFORM_HOST_TIMER_RESOLUTION = 2309;
    public static final int CL_DEVICE_IL_VERSION = 4187;
    public static final int CL_DEVICE_MAX_NUM_SUB_GROUPS = 4188;
    public static final int CL_DEVICE_SUB_GROUP_INDEPENDENT_FORWARD_PROGRESS = 4189;
    public static final int CL_QUEUE_DEVICE_DEFAULT = 4245;
    public static final int CL_UNORM_INT_101010_2 = 4320;
    public static final int CL_PROGRAM_IL = 4457;
    public static final int CL_KERNEL_MAX_NUM_SUB_GROUPS = 4537;
    public static final int CL_KERNEL_COMPILE_NUM_SUB_GROUPS = 4538;
    public static final int CL_KERNEL_MAX_SUB_GROUP_SIZE_FOR_NDRANGE = 8243;
    public static final int CL_KERNEL_SUB_GROUP_COUNT_FOR_NDRANGE = 8244;
    public static final int CL_KERNEL_LOCAL_SIZE_FOR_SUB_GROUP_COUNT = 4536;

    protected CL21() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(CLCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.clSetDefaultDeviceCommandQueue, caps.clGetDeviceAndHostTimer, caps.clGetHostTimer, caps.clCreateProgramWithIL, caps.clCloneKernel, caps.clGetKernelSubGroupInfo, caps.clEnqueueSVMMigrateMem});
    }

    @NativeType(value="cl_int")
    public static int clSetDefaultDeviceCommandQueue(@NativeType(value="cl_context") long context, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_command_queue") long command_queue) {
        long __functionAddress = CL.getICD().clSetDefaultDeviceCommandQueue;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.check((long)device);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPI((long)context, (long)device, (long)command_queue, (long)__functionAddress);
    }

    public static int nclGetDeviceAndHostTimer(long device, long device_timestamp, long host_timestamp) {
        long __functionAddress = CL.getICD().clGetDeviceAndHostTimer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.callPPPI((long)device, (long)device_timestamp, (long)host_timestamp, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceAndHostTimer(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_ulong *") LongBuffer device_timestamp, @NativeType(value="cl_ulong *") LongBuffer host_timestamp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)device_timestamp, (int)1);
            Checks.check((Buffer)host_timestamp, (int)1);
        }
        return CL21.nclGetDeviceAndHostTimer(device, MemoryUtil.memAddress((LongBuffer)device_timestamp), MemoryUtil.memAddress((LongBuffer)host_timestamp));
    }

    public static int nclGetHostTimer(long device, long host_timestamp) {
        long __functionAddress = CL.getICD().clGetHostTimer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
        }
        return JNI.callPPI((long)device, (long)host_timestamp, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetHostTimer(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_ulong *") LongBuffer host_timestamp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)host_timestamp, (int)1);
        }
        return CL21.nclGetHostTimer(device, MemoryUtil.memAddress((LongBuffer)host_timestamp));
    }

    public static long nclCreateProgramWithIL(long context, long il, long length, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithIL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPPPP((long)context, (long)il, (long)length, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithIL(@NativeType(value="cl_context") long context, @NativeType(value="void const *") ByteBuffer il, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL21.nclCreateProgramWithIL(context, MemoryUtil.memAddress((ByteBuffer)il), il.remaining(), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    public static long nclCloneKernel(long source_kernel, long errcode_ret) {
        long __functionAddress = CL.getICD().clCloneKernel;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)source_kernel);
        }
        return JNI.callPPP((long)source_kernel, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_kernel")
    public static long clCloneKernel(@NativeType(value="cl_kernel") long source_kernel, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL21.nclCloneKernel(source_kernel, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    public static int nclGetKernelSubGroupInfo(long kernel, long device, int param_name, long input_value_size, long input_value, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetKernelSubGroupInfo;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)kernel);
        }
        return JNI.callPPPPPPPI((long)kernel, (long)device, (int)param_name, (long)input_value_size, (long)input_value, (long)param_value_size, (long)param_value, (long)param_value_size_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetKernelSubGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_kernel_sub_group_info") int param_name, @Nullable @NativeType(value="void const *") ByteBuffer input_value, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL21.nclGetKernelSubGroupInfo(kernel, device, param_name, Checks.remainingSafe((Buffer)input_value), MemoryUtil.memAddressSafe((ByteBuffer)input_value), Checks.remainingSafe((Buffer)param_value), MemoryUtil.memAddressSafe((ByteBuffer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetKernelSubGroupInfo(@NativeType(value="cl_kernel") long kernel, @NativeType(value="cl_device_id") long device, @NativeType(value="cl_kernel_sub_group_info") int param_name, @Nullable @NativeType(value="void const *") ByteBuffer input_value, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)param_value_size_ret, (int)1);
        }
        return CL21.nclGetKernelSubGroupInfo(kernel, device, param_name, Checks.remainingSafe((Buffer)input_value), MemoryUtil.memAddressSafe((ByteBuffer)input_value), Integer.toUnsignedLong(Checks.remainingSafe((CustomBuffer)param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe((Pointer)param_value), MemoryUtil.memAddressSafe((Pointer)param_value_size_ret));
    }

    public static int nclEnqueueSVMMigrateMem(long command_queue, int num_svm_pointers, long svm_pointers, long sizes, long flags, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL.getICD().clEnqueueSVMMigrateMem;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)command_queue);
        }
        return JNI.callPPPJPPI((long)command_queue, (int)num_svm_pointers, (long)svm_pointers, (long)sizes, (long)flags, (int)num_events_in_wait_list, (long)event_wait_list, (long)event, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clEnqueueSVMMigrateMem(@NativeType(value="cl_command_queue") long command_queue, @NativeType(value="void const **") PointerBuffer svm_pointers, @Nullable @NativeType(value="size_t const *") PointerBuffer sizes, @NativeType(value="cl_mem_migration_flags") long flags, @Nullable @NativeType(value="cl_event const *") PointerBuffer event_wait_list, @Nullable @NativeType(value="cl_event *") PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)sizes, (int)svm_pointers.remaining());
            Checks.checkSafe((CustomBuffer)event, (int)1);
        }
        return CL21.nclEnqueueSVMMigrateMem(command_queue, svm_pointers.remaining(), MemoryUtil.memAddress((CustomBuffer)svm_pointers), MemoryUtil.memAddressSafe((Pointer)sizes), flags, Checks.remainingSafe((CustomBuffer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event_wait_list), MemoryUtil.memAddressSafe((Pointer)event));
    }

    @NativeType(value="cl_int")
    public static int clGetDeviceAndHostTimer(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_ulong *") long[] device_timestamp, @NativeType(value="cl_ulong *") long[] host_timestamp) {
        long __functionAddress = CL.getICD().clGetDeviceAndHostTimer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
            Checks.check((long[])device_timestamp, (int)1);
            Checks.check((long[])host_timestamp, (int)1);
        }
        return JNI.callPPPI((long)device, (long[])device_timestamp, (long[])host_timestamp, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetHostTimer(@NativeType(value="cl_device_id") long device, @NativeType(value="cl_ulong *") long[] host_timestamp) {
        long __functionAddress = CL.getICD().clGetHostTimer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)device);
            Checks.check((long[])host_timestamp, (int)1);
        }
        return JNI.callPPI((long)device, (long[])host_timestamp, (long)__functionAddress);
    }

    @NativeType(value="cl_program")
    public static long clCreateProgramWithIL(@NativeType(value="cl_context") long context, @NativeType(value="void const *") ByteBuffer il, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateProgramWithIL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPPPP((long)context, (long)MemoryUtil.memAddress((ByteBuffer)il), (long)il.remaining(), (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_kernel")
    public static long clCloneKernel(@NativeType(value="cl_kernel") long source_kernel, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCloneKernel;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)source_kernel);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPP((long)source_kernel, (int[])errcode_ret, (long)__functionAddress);
    }
}

