/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU92;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.cuda.CUDA_EXTERNAL_MEMORY_BUFFER_DESC;
import org.lwjgl.cuda.CUDA_EXTERNAL_MEMORY_HANDLE_DESC;
import org.lwjgl.cuda.CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC;
import org.lwjgl.cuda.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC;
import org.lwjgl.cuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS;
import org.lwjgl.cuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS;
import org.lwjgl.cuda.CUDA_HOST_NODE_PARAMS;
import org.lwjgl.cuda.CUDA_KERNEL_NODE_PARAMS;
import org.lwjgl.cuda.CUDA_MEMCPY3D;
import org.lwjgl.cuda.CUDA_MEMSET_NODE_PARAMS;
import org.lwjgl.cuda.CUhostFnI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class CU100
extends CU92 {
    public static final int CUDA_EXTERNAL_MEMORY_DEDICATED = 1;
    public static final int CU_GRAPH_NODE_TYPE_KERNEL = 0;
    public static final int CU_GRAPH_NODE_TYPE_MEMCPY = 1;
    public static final int CU_GRAPH_NODE_TYPE_MEMSET = 2;
    public static final int CU_GRAPH_NODE_TYPE_HOST = 3;
    public static final int CU_GRAPH_NODE_TYPE_GRAPH = 4;
    public static final int CU_GRAPH_NODE_TYPE_EMPTY = 5;
    public static final int CU_STREAM_CAPTURE_STATUS_NONE = 0;
    public static final int CU_STREAM_CAPTURE_STATUS_ACTIVE = 1;
    public static final int CU_STREAM_CAPTURE_STATUS_INVALIDATED = 2;
    public static final int CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD = 1;
    public static final int CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32 = 2;
    public static final int CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT = 3;
    public static final int CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP = 4;
    public static final int CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE = 5;
    public static final int CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD = 1;
    public static final int CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32 = 2;
    public static final int CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT = 3;
    public static final int CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE = 4;

    protected CU100() {
        throw new UnsupportedOperationException();
    }

    public static int ncuDeviceGetLuid(long luid, long deviceNodeMask, int dev) {
        long __functionAddress = Functions.DeviceGetLuid;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)luid, (long)deviceNodeMask, (int)dev, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuDeviceGetLuid(@NativeType(value="char *") ByteBuffer luid, @NativeType(value="unsigned int *") IntBuffer deviceNodeMask, @NativeType(value="CUdevice") int dev) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)luid, (int)8);
            Checks.check((Buffer)deviceNodeMask, (int)1);
        }
        return CU100.ncuDeviceGetLuid(MemoryUtil.memAddress((ByteBuffer)luid), MemoryUtil.memAddress((IntBuffer)deviceNodeMask), dev);
    }

    @NativeType(value="CUresult")
    public static int cuStreamBeginCapture(@NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.StreamBeginCapture;
        return JNI.callPI((long)hStream, (long)__functionAddress);
    }

    public static int ncuStreamEndCapture(long hStream, long phGraph) {
        long __functionAddress = Functions.StreamEndCapture;
        return JNI.callPPI((long)hStream, (long)phGraph, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamEndCapture(@NativeType(value="CUstream") long hStream, @NativeType(value="CUgraph *") PointerBuffer phGraph) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraph, (int)1);
        }
        return CU100.ncuStreamEndCapture(hStream, MemoryUtil.memAddress((CustomBuffer)phGraph));
    }

    public static int ncuStreamIsCapturing(long hStream, long captureStatus) {
        long __functionAddress = Functions.StreamIsCapturing;
        return JNI.callPPI((long)hStream, (long)captureStatus, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamIsCapturing(@NativeType(value="CUstream") long hStream, @NativeType(value="CUstreamCaptureStatus *") IntBuffer captureStatus) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)captureStatus, (int)1);
        }
        return CU100.ncuStreamIsCapturing(hStream, MemoryUtil.memAddress((IntBuffer)captureStatus));
    }

    public static int ncuImportExternalMemory(long extMem_out, long memHandleDesc) {
        long __functionAddress = Functions.ImportExternalMemory;
        return JNI.callPPI((long)extMem_out, (long)memHandleDesc, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuImportExternalMemory(@NativeType(value="CUexternalMemory *") PointerBuffer extMem_out, @NativeType(value="CUDA_EXTERNAL_MEMORY_HANDLE_DESC const *") CUDA_EXTERNAL_MEMORY_HANDLE_DESC memHandleDesc) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)extMem_out, (int)1);
        }
        return CU100.ncuImportExternalMemory(MemoryUtil.memAddress((CustomBuffer)extMem_out), memHandleDesc.address());
    }

    public static int ncuExternalMemoryGetMappedBuffer(long devPtr, long extMem, long bufferDesc) {
        long __functionAddress = Functions.ExternalMemoryGetMappedBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)extMem);
        }
        return JNI.callPPPI((long)devPtr, (long)extMem, (long)bufferDesc, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuExternalMemoryGetMappedBuffer(@NativeType(value="CUdeviceptr *") PointerBuffer devPtr, @NativeType(value="CUexternalMemory") long extMem, @NativeType(value="CUDA_EXTERNAL_MEMORY_BUFFER_DESC const *") CUDA_EXTERNAL_MEMORY_BUFFER_DESC bufferDesc) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)devPtr, (int)1);
        }
        return CU100.ncuExternalMemoryGetMappedBuffer(MemoryUtil.memAddress((CustomBuffer)devPtr), extMem, bufferDesc.address());
    }

    public static int ncuExternalMemoryGetMappedMipmappedArray(long mipmap, long extMem, long mipmapDesc) {
        long __functionAddress = Functions.ExternalMemoryGetMappedMipmappedArray;
        if (Checks.CHECKS) {
            Checks.check((long)extMem);
        }
        return JNI.callPPPI((long)mipmap, (long)extMem, (long)mipmapDesc, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuExternalMemoryGetMappedMipmappedArray(@NativeType(value="CUmipmappedArray *") PointerBuffer mipmap, @NativeType(value="CUexternalMemory") long extMem, @NativeType(value="CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC const *") CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC mipmapDesc) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)mipmap, (int)1);
        }
        return CU100.ncuExternalMemoryGetMappedMipmappedArray(MemoryUtil.memAddress((CustomBuffer)mipmap), extMem, mipmapDesc.address());
    }

    @NativeType(value="CUresult")
    public static int cuDestroyExternalMemory(@NativeType(value="CUexternalMemory") long extMem) {
        long __functionAddress = Functions.DestroyExternalMemory;
        if (Checks.CHECKS) {
            Checks.check((long)extMem);
        }
        return JNI.callPI((long)extMem, (long)__functionAddress);
    }

    public static int ncuImportExternalSemaphore(long extSem_out, long semHandleDesc) {
        long __functionAddress = Functions.ImportExternalSemaphore;
        return JNI.callPPI((long)extSem_out, (long)semHandleDesc, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuImportExternalSemaphore(@NativeType(value="CUexternalSemaphore *") PointerBuffer extSem_out, @NativeType(value="CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC const *") CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC semHandleDesc) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)extSem_out, (int)1);
        }
        return CU100.ncuImportExternalSemaphore(MemoryUtil.memAddress((CustomBuffer)extSem_out), semHandleDesc.address());
    }

    public static int ncuSignalExternalSemaphoresAsync(long extSemArray, long paramsArray, int numExtSems, long stream) {
        long __functionAddress = Functions.SignalExternalSemaphoresAsync;
        return JNI.callPPPI((long)extSemArray, (long)paramsArray, (int)numExtSems, (long)stream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuSignalExternalSemaphoresAsync(@NativeType(value="CUexternalSemaphore const *") PointerBuffer extSemArray, @Nullable @NativeType(value="CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS const *") CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS.Buffer paramsArray, @NativeType(value="CUstream") long stream) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)paramsArray, (int)extSemArray.remaining());
        }
        return CU100.ncuSignalExternalSemaphoresAsync(MemoryUtil.memAddress((CustomBuffer)extSemArray), MemoryUtil.memAddressSafe((Pointer)paramsArray), extSemArray.remaining(), stream);
    }

    public static int ncuWaitExternalSemaphoresAsync(long extSemArray, long paramsArray, int numExtSems, long stream) {
        long __functionAddress = Functions.WaitExternalSemaphoresAsync;
        return JNI.callPPPI((long)extSemArray, (long)paramsArray, (int)numExtSems, (long)stream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuWaitExternalSemaphoresAsync(@NativeType(value="CUexternalSemaphore const *") PointerBuffer extSemArray, @Nullable @NativeType(value="CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS const *") CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS.Buffer paramsArray, @NativeType(value="CUstream") long stream) {
        if (Checks.CHECKS) {
            Checks.checkSafe((CustomBuffer)paramsArray, (int)extSemArray.remaining());
        }
        return CU100.ncuWaitExternalSemaphoresAsync(MemoryUtil.memAddress((CustomBuffer)extSemArray), MemoryUtil.memAddressSafe((Pointer)paramsArray), extSemArray.remaining(), stream);
    }

    @NativeType(value="CUresult")
    public static int cuDestroyExternalSemaphore(@NativeType(value="CUexternalSemaphore") long extSem) {
        long __functionAddress = Functions.DestroyExternalSemaphore;
        if (Checks.CHECKS) {
            Checks.check((long)extSem);
        }
        return JNI.callPI((long)extSem, (long)__functionAddress);
    }

    public static int ncuLaunchHostFunc(long hStream, long fn, long userData) {
        long __functionAddress = Functions.LaunchHostFunc;
        if (Checks.CHECKS) {
            Checks.check((long)userData);
        }
        return JNI.callPPPI((long)hStream, (long)fn, (long)userData, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuLaunchHostFunc(@NativeType(value="CUstream") long hStream, @NativeType(value="void (*) (void *)") CUhostFnI fn, @NativeType(value="void *") long userData) {
        return CU100.ncuLaunchHostFunc(hStream, fn.address(), userData);
    }

    public static int ncuGraphCreate(long phGraph, int flags) {
        long __functionAddress = Functions.GraphCreate;
        return JNI.callPI((long)phGraph, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphCreate(@NativeType(value="CUgraph *") PointerBuffer phGraph, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraph, (int)1);
        }
        return CU100.ncuGraphCreate(MemoryUtil.memAddress((CustomBuffer)phGraph), flags);
    }

    public static int ncuGraphAddKernelNode(long phGraphNode, long hGraph, long dependencies, long numDependencies, long nodeParams) {
        long __functionAddress = Functions.GraphAddKernelNode;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
            CUDA_KERNEL_NODE_PARAMS.validate(nodeParams);
        }
        return JNI.callPPPPPI((long)phGraphNode, (long)hGraph, (long)dependencies, (long)numDependencies, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphAddKernelNode(@NativeType(value="CUgraphNode *") PointerBuffer phGraphNode, @NativeType(value="CUgraph") long hGraph, @Nullable @NativeType(value="CUgraphNode const *") PointerBuffer dependencies, @NativeType(value="CUDA_KERNEL_NODE_PARAMS const *") CUDA_KERNEL_NODE_PARAMS nodeParams) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraphNode, (int)1);
        }
        return CU100.ncuGraphAddKernelNode(MemoryUtil.memAddress((CustomBuffer)phGraphNode), hGraph, MemoryUtil.memAddressSafe((Pointer)dependencies), Checks.remainingSafe((CustomBuffer)dependencies), nodeParams.address());
    }

    public static int ncuGraphKernelNodeGetParams(long hNode, long nodeParams) {
        long __functionAddress = Functions.GraphKernelNodeGetParams;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
        }
        return JNI.callPPI((long)hNode, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphKernelNodeGetParams(@NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUDA_KERNEL_NODE_PARAMS *") CUDA_KERNEL_NODE_PARAMS nodeParams) {
        return CU100.ncuGraphKernelNodeGetParams(hNode, nodeParams.address());
    }

    public static int ncuGraphKernelNodeSetParams(long hNode, long nodeParams) {
        long __functionAddress = Functions.GraphKernelNodeSetParams;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
            CUDA_KERNEL_NODE_PARAMS.validate(nodeParams);
        }
        return JNI.callPPI((long)hNode, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphKernelNodeSetParams(@NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUDA_KERNEL_NODE_PARAMS const *") CUDA_KERNEL_NODE_PARAMS nodeParams) {
        return CU100.ncuGraphKernelNodeSetParams(hNode, nodeParams.address());
    }

    public static int ncuGraphAddMemcpyNode(long phGraphNode, long hGraph, long dependencies, long numDependencies, long copyParams, long ctx) {
        long __functionAddress = Functions.GraphAddMemcpyNode;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
            CUDA_MEMCPY3D.validate(copyParams);
            Checks.check((long)ctx);
        }
        return JNI.callPPPPPPI((long)phGraphNode, (long)hGraph, (long)dependencies, (long)numDependencies, (long)copyParams, (long)ctx, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphAddMemcpyNode(@NativeType(value="CUgraphNode *") PointerBuffer phGraphNode, @NativeType(value="CUgraph") long hGraph, @Nullable @NativeType(value="CUgraphNode const *") PointerBuffer dependencies, @NativeType(value="CUDA_MEMCPY3D const *") CUDA_MEMCPY3D copyParams, @NativeType(value="CUcontext") long ctx) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraphNode, (int)1);
        }
        return CU100.ncuGraphAddMemcpyNode(MemoryUtil.memAddress((CustomBuffer)phGraphNode), hGraph, MemoryUtil.memAddressSafe((Pointer)dependencies), Checks.remainingSafe((CustomBuffer)dependencies), copyParams.address(), ctx);
    }

    public static int ncuGraphMemcpyNodeGetParams(long hNode, long nodeParams) {
        long __functionAddress = Functions.GraphMemcpyNodeGetParams;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
        }
        return JNI.callPPI((long)hNode, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphMemcpyNodeGetParams(@NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUDA_MEMCPY3D *") CUDA_MEMCPY3D nodeParams) {
        return CU100.ncuGraphMemcpyNodeGetParams(hNode, nodeParams.address());
    }

    public static int ncuGraphMemcpyNodeSetParams(long hNode, long nodeParams) {
        long __functionAddress = Functions.GraphMemcpyNodeSetParams;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
            CUDA_MEMCPY3D.validate(nodeParams);
        }
        return JNI.callPPI((long)hNode, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphMemcpyNodeSetParams(@NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUDA_MEMCPY3D const *") CUDA_MEMCPY3D nodeParams) {
        return CU100.ncuGraphMemcpyNodeSetParams(hNode, nodeParams.address());
    }

    public static int ncuGraphAddMemsetNode(long phGraphNode, long hGraph, long dependencies, long numDependencies, long memsetParams, long ctx) {
        long __functionAddress = Functions.GraphAddMemsetNode;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
            CUDA_MEMSET_NODE_PARAMS.validate(memsetParams);
            Checks.check((long)ctx);
        }
        return JNI.callPPPPPPI((long)phGraphNode, (long)hGraph, (long)dependencies, (long)numDependencies, (long)memsetParams, (long)ctx, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphAddMemsetNode(@NativeType(value="CUgraphNode *") PointerBuffer phGraphNode, @NativeType(value="CUgraph") long hGraph, @Nullable @NativeType(value="CUgraphNode const *") PointerBuffer dependencies, @NativeType(value="CUDA_MEMSET_NODE_PARAMS const *") CUDA_MEMSET_NODE_PARAMS memsetParams, @NativeType(value="CUcontext") long ctx) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraphNode, (int)1);
        }
        return CU100.ncuGraphAddMemsetNode(MemoryUtil.memAddress((CustomBuffer)phGraphNode), hGraph, MemoryUtil.memAddressSafe((Pointer)dependencies), Checks.remainingSafe((CustomBuffer)dependencies), memsetParams.address(), ctx);
    }

    public static int ncuGraphMemsetNodeGetParams(long hNode, long nodeParams) {
        long __functionAddress = Functions.GraphMemsetNodeGetParams;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
        }
        return JNI.callPPI((long)hNode, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphMemsetNodeGetParams(@NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUDA_MEMSET_NODE_PARAMS *") CUDA_MEMSET_NODE_PARAMS nodeParams) {
        return CU100.ncuGraphMemsetNodeGetParams(hNode, nodeParams.address());
    }

    public static int ncuGraphMemsetNodeSetParams(long hNode, long nodeParams) {
        long __functionAddress = Functions.GraphMemsetNodeSetParams;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
            CUDA_MEMSET_NODE_PARAMS.validate(nodeParams);
        }
        return JNI.callPPI((long)hNode, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphMemsetNodeSetParams(@NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUDA_MEMSET_NODE_PARAMS const *") CUDA_MEMSET_NODE_PARAMS nodeParams) {
        return CU100.ncuGraphMemsetNodeSetParams(hNode, nodeParams.address());
    }

    public static int ncuGraphAddHostNode(long phGraphNode, long hGraph, long dependencies, long numDependencies, long nodeParams) {
        long __functionAddress = Functions.GraphAddHostNode;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
            CUDA_HOST_NODE_PARAMS.validate(nodeParams);
        }
        return JNI.callPPPPPI((long)phGraphNode, (long)hGraph, (long)dependencies, (long)numDependencies, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphAddHostNode(@NativeType(value="CUgraphNode *") PointerBuffer phGraphNode, @NativeType(value="CUgraph") long hGraph, @Nullable @NativeType(value="CUgraphNode const *") PointerBuffer dependencies, @NativeType(value="CUDA_HOST_NODE_PARAMS const *") CUDA_HOST_NODE_PARAMS nodeParams) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraphNode, (int)1);
        }
        return CU100.ncuGraphAddHostNode(MemoryUtil.memAddress((CustomBuffer)phGraphNode), hGraph, MemoryUtil.memAddressSafe((Pointer)dependencies), Checks.remainingSafe((CustomBuffer)dependencies), nodeParams.address());
    }

    public static int ncuGraphHostNodeGetParams(long hNode, long nodeParams) {
        long __functionAddress = Functions.GraphHostNodeGetParams;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
        }
        return JNI.callPPI((long)hNode, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphHostNodeGetParams(@NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUDA_HOST_NODE_PARAMS *") CUDA_HOST_NODE_PARAMS nodeParams) {
        return CU100.ncuGraphHostNodeGetParams(hNode, nodeParams.address());
    }

    public static int ncuGraphHostNodeSetParams(long hNode, long nodeParams) {
        long __functionAddress = Functions.GraphHostNodeSetParams;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
            CUDA_HOST_NODE_PARAMS.validate(nodeParams);
        }
        return JNI.callPPI((long)hNode, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphHostNodeSetParams(@NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUDA_HOST_NODE_PARAMS const *") CUDA_HOST_NODE_PARAMS nodeParams) {
        return CU100.ncuGraphHostNodeSetParams(hNode, nodeParams.address());
    }

    public static int ncuGraphAddChildGraphNode(long phGraphNode, long hGraph, long dependencies, long numDependencies, long childGraph) {
        long __functionAddress = Functions.GraphAddChildGraphNode;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
            Checks.check((long)childGraph);
        }
        return JNI.callPPPPPI((long)phGraphNode, (long)hGraph, (long)dependencies, (long)numDependencies, (long)childGraph, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphAddChildGraphNode(@NativeType(value="CUgraphNode *") PointerBuffer phGraphNode, @NativeType(value="CUgraph") long hGraph, @Nullable @NativeType(value="CUgraphNode const *") PointerBuffer dependencies, @NativeType(value="CUgraph") long childGraph) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraphNode, (int)1);
        }
        return CU100.ncuGraphAddChildGraphNode(MemoryUtil.memAddress((CustomBuffer)phGraphNode), hGraph, MemoryUtil.memAddressSafe((Pointer)dependencies), Checks.remainingSafe((CustomBuffer)dependencies), childGraph);
    }

    public static int ncuGraphChildGraphNodeGetGraph(long hNode, long phGraph) {
        long __functionAddress = Functions.GraphChildGraphNodeGetGraph;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
        }
        return JNI.callPPI((long)hNode, (long)phGraph, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphChildGraphNodeGetGraph(@NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUgraph *") PointerBuffer phGraph) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraph, (int)1);
        }
        return CU100.ncuGraphChildGraphNodeGetGraph(hNode, MemoryUtil.memAddress((CustomBuffer)phGraph));
    }

    public static int ncuGraphAddEmptyNode(long phGraphNode, long hGraph, long dependencies, long numDependencies) {
        long __functionAddress = Functions.GraphAddEmptyNode;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
        }
        return JNI.callPPPPI((long)phGraphNode, (long)hGraph, (long)dependencies, (long)numDependencies, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphAddEmptyNode(@NativeType(value="CUgraphNode *") PointerBuffer phGraphNode, @NativeType(value="CUgraph") long hGraph, @Nullable @NativeType(value="CUgraphNode const *") PointerBuffer dependencies) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraphNode, (int)1);
        }
        return CU100.ncuGraphAddEmptyNode(MemoryUtil.memAddress((CustomBuffer)phGraphNode), hGraph, MemoryUtil.memAddressSafe((Pointer)dependencies), Checks.remainingSafe((CustomBuffer)dependencies));
    }

    public static int ncuGraphClone(long phGraphClone, long originalGraph) {
        long __functionAddress = Functions.GraphClone;
        if (Checks.CHECKS) {
            Checks.check((long)originalGraph);
        }
        return JNI.callPPI((long)phGraphClone, (long)originalGraph, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphClone(@NativeType(value="CUgraph *") PointerBuffer phGraphClone, @NativeType(value="CUgraph") long originalGraph) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraphClone, (int)1);
        }
        return CU100.ncuGraphClone(MemoryUtil.memAddress((CustomBuffer)phGraphClone), originalGraph);
    }

    public static int ncuGraphNodeFindInClone(long phNode, long hOriginalNode, long hClonedGraph) {
        long __functionAddress = Functions.GraphNodeFindInClone;
        if (Checks.CHECKS) {
            Checks.check((long)hOriginalNode);
            Checks.check((long)hClonedGraph);
        }
        return JNI.callPPPI((long)phNode, (long)hOriginalNode, (long)hClonedGraph, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphNodeFindInClone(@NativeType(value="CUgraphNode *") PointerBuffer phNode, @NativeType(value="CUgraphNode") long hOriginalNode, @NativeType(value="CUgraph") long hClonedGraph) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phNode, (int)1);
        }
        return CU100.ncuGraphNodeFindInClone(MemoryUtil.memAddress((CustomBuffer)phNode), hOriginalNode, hClonedGraph);
    }

    public static int ncuGraphNodeGetType(long hNode, long type) {
        long __functionAddress = Functions.GraphNodeGetType;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
        }
        return JNI.callPPI((long)hNode, (long)type, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphNodeGetType(@NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUgraphNodeType *") IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)type, (int)1);
        }
        return CU100.ncuGraphNodeGetType(hNode, MemoryUtil.memAddress((IntBuffer)type));
    }

    public static int ncuGraphGetNodes(long hGraph, long nodes, long numNodes) {
        long __functionAddress = Functions.GraphGetNodes;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
        }
        return JNI.callPPPI((long)hGraph, (long)nodes, (long)numNodes, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphGetNodes(@NativeType(value="CUgraph") long hGraph, @Nullable @NativeType(value="CUgraphNode *") PointerBuffer nodes, @NativeType(value="size_t *") PointerBuffer numNodes) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)numNodes, (int)1);
            Checks.checkSafe((CustomBuffer)nodes, (long)numNodes.get(numNodes.position()));
        }
        return CU100.ncuGraphGetNodes(hGraph, MemoryUtil.memAddressSafe((Pointer)nodes), MemoryUtil.memAddress((CustomBuffer)numNodes));
    }

    public static int ncuGraphGetRootNodes(long hGraph, long rootNodes, long numRootNodes) {
        long __functionAddress = Functions.GraphGetRootNodes;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
        }
        return JNI.callPPPI((long)hGraph, (long)rootNodes, (long)numRootNodes, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphGetRootNodes(@NativeType(value="CUgraph") long hGraph, @Nullable @NativeType(value="CUgraphNode *") PointerBuffer rootNodes, @NativeType(value="size_t *") PointerBuffer numRootNodes) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)numRootNodes, (int)1);
            Checks.checkSafe((CustomBuffer)rootNodes, (long)numRootNodes.get(numRootNodes.position()));
        }
        return CU100.ncuGraphGetRootNodes(hGraph, MemoryUtil.memAddressSafe((Pointer)rootNodes), MemoryUtil.memAddress((CustomBuffer)numRootNodes));
    }

    public static int ncuGraphGetEdges(long hGraph, long from, long to, long numEdges) {
        long __functionAddress = Functions.GraphGetEdges;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
        }
        return JNI.callPPPPI((long)hGraph, (long)from, (long)to, (long)numEdges, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphGetEdges(@NativeType(value="CUgraph") long hGraph, @Nullable @NativeType(value="CUgraphNode *") PointerBuffer from, @Nullable @NativeType(value="CUgraphNode *") PointerBuffer to, @NativeType(value="size_t *") PointerBuffer numEdges) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)numEdges, (int)1);
            Checks.checkSafe((CustomBuffer)from, (long)numEdges.get(numEdges.position()));
            Checks.checkSafe((CustomBuffer)to, (long)numEdges.get(numEdges.position()));
        }
        return CU100.ncuGraphGetEdges(hGraph, MemoryUtil.memAddressSafe((Pointer)from), MemoryUtil.memAddressSafe((Pointer)to), MemoryUtil.memAddress((CustomBuffer)numEdges));
    }

    public static int ncuGraphNodeGetDependencies(long hNode, long dependencies, long numDependencies) {
        long __functionAddress = Functions.GraphNodeGetDependencies;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
        }
        return JNI.callPPPI((long)hNode, (long)dependencies, (long)numDependencies, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphNodeGetDependencies(@NativeType(value="CUgraphNode") long hNode, @Nullable @NativeType(value="CUgraphNode *") PointerBuffer dependencies, @NativeType(value="size_t *") PointerBuffer numDependencies) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)numDependencies, (int)1);
            Checks.checkSafe((CustomBuffer)dependencies, (long)numDependencies.get(numDependencies.position()));
        }
        return CU100.ncuGraphNodeGetDependencies(hNode, MemoryUtil.memAddressSafe((Pointer)dependencies), MemoryUtil.memAddress((CustomBuffer)numDependencies));
    }

    public static int ncuGraphNodeGetDependentNodes(long hNode, long dependentNodes, long numDependentNodes) {
        long __functionAddress = Functions.GraphNodeGetDependentNodes;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
        }
        return JNI.callPPPI((long)hNode, (long)dependentNodes, (long)numDependentNodes, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphNodeGetDependentNodes(@NativeType(value="CUgraphNode") long hNode, @Nullable @NativeType(value="CUgraphNode *") PointerBuffer dependentNodes, @NativeType(value="size_t *") PointerBuffer numDependentNodes) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)numDependentNodes, (int)1);
            Checks.checkSafe((CustomBuffer)dependentNodes, (long)numDependentNodes.get(numDependentNodes.position()));
        }
        return CU100.ncuGraphNodeGetDependentNodes(hNode, MemoryUtil.memAddressSafe((Pointer)dependentNodes), MemoryUtil.memAddress((CustomBuffer)numDependentNodes));
    }

    public static int ncuGraphAddDependencies(long hGraph, long from, long to, long numDependencies) {
        long __functionAddress = Functions.GraphAddDependencies;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
        }
        return JNI.callPPPPI((long)hGraph, (long)from, (long)to, (long)numDependencies, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphAddDependencies(@NativeType(value="CUgraph") long hGraph, @NativeType(value="CUgraphNode const *") PointerBuffer from, @NativeType(value="CUgraphNode const *") PointerBuffer to) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)to, (int)from.remaining());
        }
        return CU100.ncuGraphAddDependencies(hGraph, MemoryUtil.memAddress((CustomBuffer)from), MemoryUtil.memAddress((CustomBuffer)to), from.remaining());
    }

    public static int ncuGraphRemoveDependencies(long hGraph, long from, long to, long numDependencies) {
        long __functionAddress = Functions.GraphRemoveDependencies;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
        }
        return JNI.callPPPPI((long)hGraph, (long)from, (long)to, (long)numDependencies, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphRemoveDependencies(@NativeType(value="CUgraph") long hGraph, @NativeType(value="CUgraphNode const *") PointerBuffer from, @NativeType(value="CUgraphNode const *") PointerBuffer to) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)to, (int)from.remaining());
        }
        return CU100.ncuGraphRemoveDependencies(hGraph, MemoryUtil.memAddress((CustomBuffer)from), MemoryUtil.memAddress((CustomBuffer)to), from.remaining());
    }

    @NativeType(value="CUresult")
    public static int cuGraphDestroyNode(@NativeType(value="CUgraphNode") long hNode) {
        long __functionAddress = Functions.GraphDestroyNode;
        if (Checks.CHECKS) {
            Checks.check((long)hNode);
        }
        return JNI.callPI((long)hNode, (long)__functionAddress);
    }

    public static int ncuGraphInstantiate(long phGraphExec, long hGraph, long phErrorNode, long logBuffer, long bufferSize) {
        long __functionAddress = Functions.GraphInstantiate;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
        }
        return JNI.callPPPPPI((long)phGraphExec, (long)hGraph, (long)phErrorNode, (long)logBuffer, (long)bufferSize, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphInstantiate(@NativeType(value="CUgraphExec *") PointerBuffer phGraphExec, @NativeType(value="CUgraph") long hGraph, @NativeType(value="CUgraphNode *") PointerBuffer phErrorNode, @NativeType(value="char *") ByteBuffer logBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)phGraphExec, (int)1);
            Checks.check((CustomBuffer)phErrorNode, (int)1);
        }
        return CU100.ncuGraphInstantiate(MemoryUtil.memAddress((CustomBuffer)phGraphExec), hGraph, MemoryUtil.memAddress((CustomBuffer)phErrorNode), MemoryUtil.memAddress((ByteBuffer)logBuffer), logBuffer.remaining());
    }

    @NativeType(value="CUresult")
    public static int cuGraphLaunch(@NativeType(value="CUgraphExec") long hGraphExec, @NativeType(value="CUstream") long hStream) {
        long __functionAddress = Functions.GraphLaunch;
        if (Checks.CHECKS) {
            Checks.check((long)hGraphExec);
        }
        return JNI.callPPI((long)hGraphExec, (long)hStream, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphExecDestroy(@NativeType(value="CUgraphExec") long hGraphExec) {
        long __functionAddress = Functions.GraphExecDestroy;
        if (Checks.CHECKS) {
            Checks.check((long)hGraphExec);
        }
        return JNI.callPI((long)hGraphExec, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphDestroy(@NativeType(value="CUgraph") long hGraph) {
        long __functionAddress = Functions.GraphDestroy;
        if (Checks.CHECKS) {
            Checks.check((long)hGraph);
        }
        return JNI.callPI((long)hGraph, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long DeviceGetLuid = CU.getLibrary().getFunctionAddress((CharSequence)"cuDeviceGetLuid");
        public static final long StreamBeginCapture = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamBeginCapture"));
        public static final long StreamEndCapture = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamEndCapture"));
        public static final long StreamIsCapturing = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamIsCapturing"));
        public static final long ImportExternalMemory = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuImportExternalMemory");
        public static final long ExternalMemoryGetMappedBuffer = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuExternalMemoryGetMappedBuffer");
        public static final long ExternalMemoryGetMappedMipmappedArray = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuExternalMemoryGetMappedMipmappedArray");
        public static final long DestroyExternalMemory = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDestroyExternalMemory");
        public static final long ImportExternalSemaphore = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuImportExternalSemaphore");
        public static final long SignalExternalSemaphoresAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuSignalExternalSemaphoresAsync"));
        public static final long WaitExternalSemaphoresAsync = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuWaitExternalSemaphoresAsync"));
        public static final long DestroyExternalSemaphore = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuDestroyExternalSemaphore");
        public static final long LaunchHostFunc = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuLaunchHostFunc"));
        public static final long GraphCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphCreate");
        public static final long GraphAddKernelNode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphAddKernelNode");
        public static final long GraphKernelNodeGetParams = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphKernelNodeGetParams");
        public static final long GraphKernelNodeSetParams = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphKernelNodeSetParams");
        public static final long GraphAddMemcpyNode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphAddMemcpyNode");
        public static final long GraphMemcpyNodeGetParams = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphMemcpyNodeGetParams");
        public static final long GraphMemcpyNodeSetParams = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphMemcpyNodeSetParams");
        public static final long GraphAddMemsetNode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphAddMemsetNode");
        public static final long GraphMemsetNodeGetParams = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphMemsetNodeGetParams");
        public static final long GraphMemsetNodeSetParams = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphMemsetNodeSetParams");
        public static final long GraphAddHostNode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphAddHostNode");
        public static final long GraphHostNodeGetParams = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphHostNodeGetParams");
        public static final long GraphHostNodeSetParams = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphHostNodeSetParams");
        public static final long GraphAddChildGraphNode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphAddChildGraphNode");
        public static final long GraphChildGraphNodeGetGraph = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphChildGraphNodeGetGraph");
        public static final long GraphAddEmptyNode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphAddEmptyNode");
        public static final long GraphClone = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphClone");
        public static final long GraphNodeFindInClone = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphNodeFindInClone");
        public static final long GraphNodeGetType = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphNodeGetType");
        public static final long GraphGetNodes = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphGetNodes");
        public static final long GraphGetRootNodes = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphGetRootNodes");
        public static final long GraphGetEdges = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphGetEdges");
        public static final long GraphNodeGetDependencies = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphNodeGetDependencies");
        public static final long GraphNodeGetDependentNodes = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphNodeGetDependentNodes");
        public static final long GraphAddDependencies = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphAddDependencies");
        public static final long GraphRemoveDependencies = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphRemoveDependencies");
        public static final long GraphDestroyNode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphDestroyNode");
        public static final long GraphInstantiate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphInstantiate");
        public static final long GraphLaunch = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuGraphLaunch"));
        public static final long GraphExecDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphExecDestroy");
        public static final long GraphDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphDestroy");

        private Functions() {
        }
    }
}

