/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU100;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.cuda.CUDA_KERNEL_NODE_PARAMS;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CU101
extends CU100 {
    public static final int CU_STREAM_CAPTURE_MODE_GLOBAL = 0;
    public static final int CU_STREAM_CAPTURE_MODE_THREAD_LOCAL = 1;
    public static final int CU_STREAM_CAPTURE_MODE_RELAXED = 2;

    protected CU101() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="CUresult")
    public static int cuStreamBeginCapture_v2(@NativeType(value="CUstream") long hStream, @NativeType(value="CUstreamCaptureMode") int mode) {
        long __functionAddress = Functions.StreamBeginCapture_v2;
        return JNI.callPI((long)hStream, (int)mode, (long)__functionAddress);
    }

    public static int ncuThreadExchangeStreamCaptureMode(long mode) {
        long __functionAddress = Functions.ThreadExchangeStreamCaptureMode;
        return JNI.callPI((long)mode, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuThreadExchangeStreamCaptureMode(@NativeType(value="CUstreamCaptureMode *") IntBuffer mode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)mode, (int)1);
        }
        return CU101.ncuThreadExchangeStreamCaptureMode(MemoryUtil.memAddress((IntBuffer)mode));
    }

    public static int ncuStreamGetCaptureInfo(long hStream, long captureStatus, long id) {
        long __functionAddress = Functions.StreamGetCaptureInfo;
        if (Checks.CHECKS) {
            Checks.check((long)hStream);
        }
        return JNI.callPPPI((long)hStream, (long)captureStatus, (long)id, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuStreamGetCaptureInfo(@NativeType(value="CUstream") long hStream, @NativeType(value="CUstreamCaptureStatus *") IntBuffer captureStatus, @NativeType(value="cuuint64_t *") LongBuffer id) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)captureStatus, (int)1);
            Checks.check((Buffer)id, (int)1);
        }
        return CU101.ncuStreamGetCaptureInfo(hStream, MemoryUtil.memAddress((IntBuffer)captureStatus), MemoryUtil.memAddress((LongBuffer)id));
    }

    public static int ncuGraphExecKernelNodeSetParams(long hGraphExec, long hNode, long nodeParams) {
        long __functionAddress = Functions.GraphExecKernelNodeSetParams;
        if (Checks.CHECKS) {
            Checks.check((long)hGraphExec);
            Checks.check((long)hNode);
            CUDA_KERNEL_NODE_PARAMS.validate(nodeParams);
        }
        return JNI.callPPPI((long)hGraphExec, (long)hNode, (long)nodeParams, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphExecKernelNodeSetParams(@NativeType(value="CUgraphExec") long hGraphExec, @NativeType(value="CUgraphNode") long hNode, @NativeType(value="CUDA_KERNEL_NODE_PARAMS const *") CUDA_KERNEL_NODE_PARAMS nodeParams) {
        return CU101.ncuGraphExecKernelNodeSetParams(hGraphExec, hNode, nodeParams.address());
    }

    public static final class Functions {
        public static final long StreamBeginCapture_v2 = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)CUDA.__CUDA_API_PTSZ("cuStreamBeginCapture_v2"));
        public static final long ThreadExchangeStreamCaptureMode = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuThreadExchangeStreamCaptureMode");
        public static final long StreamGetCaptureInfo = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuStreamGetCaptureInfo");
        public static final long GraphExecKernelNodeSetParams = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphExecKernelNodeSetParams");

        private Functions() {
        }
    }
}

