/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU60;
import org.lwjgl.cuda.CUoccupancyB2DSizeI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class CU65
extends CU60 {
    public static final int CU_OCCUPANCY_DEFAULT = 0;
    public static final int CU_OCCUPANCY_DISABLE_CACHING_OVERRIDE = 1;

    protected CU65() {
        throw new UnsupportedOperationException();
    }

    public static int ncuOccupancyMaxActiveBlocksPerMultiprocessor(long numBlocks, long func, int blockSize, long dynamicSMemSize) {
        long __functionAddress = Functions.OccupancyMaxActiveBlocksPerMultiprocessor;
        if (Checks.CHECKS) {
            Checks.check((long)func);
        }
        return JNI.callPPPI((long)numBlocks, (long)func, (int)blockSize, (long)dynamicSMemSize, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuOccupancyMaxActiveBlocksPerMultiprocessor(@NativeType(value="int *") IntBuffer numBlocks, @NativeType(value="CUfunction") long func, int blockSize, @NativeType(value="size_t") long dynamicSMemSize) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)numBlocks, (int)1);
        }
        return CU65.ncuOccupancyMaxActiveBlocksPerMultiprocessor(MemoryUtil.memAddress((IntBuffer)numBlocks), func, blockSize, dynamicSMemSize);
    }

    public static int ncuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(long numBlocks, long func, int blockSize, long dynamicSMemSize, int flags) {
        long __functionAddress = Functions.OccupancyMaxActiveBlocksPerMultiprocessorWithFlags;
        if (Checks.CHECKS) {
            Checks.check((long)func);
        }
        return JNI.callPPPI((long)numBlocks, (long)func, (int)blockSize, (long)dynamicSMemSize, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(@NativeType(value="int *") IntBuffer numBlocks, @NativeType(value="CUfunction") long func, int blockSize, @NativeType(value="size_t") long dynamicSMemSize, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)numBlocks, (int)1);
        }
        return CU65.ncuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags(MemoryUtil.memAddress((IntBuffer)numBlocks), func, blockSize, dynamicSMemSize, flags);
    }

    public static int ncuOccupancyMaxPotentialBlockSize(long minGridSize, long blockSize, long func, long blockSizeToDynamicSMemSize, long dynamicSMemSize, int blockSizeLimit) {
        long __functionAddress = Functions.OccupancyMaxPotentialBlockSize;
        if (Checks.CHECKS) {
            Checks.check((long)func);
        }
        return JNI.callPPPPPI((long)minGridSize, (long)blockSize, (long)func, (long)blockSizeToDynamicSMemSize, (long)dynamicSMemSize, (int)blockSizeLimit, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuOccupancyMaxPotentialBlockSize(@NativeType(value="int *") IntBuffer minGridSize, @NativeType(value="int *") IntBuffer blockSize, @NativeType(value="CUfunction") long func, @Nullable @NativeType(value="size_t (*) (int)") CUoccupancyB2DSizeI blockSizeToDynamicSMemSize, @NativeType(value="size_t") long dynamicSMemSize, int blockSizeLimit) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)minGridSize, (int)1);
            Checks.check((Buffer)blockSize, (int)1);
        }
        return CU65.ncuOccupancyMaxPotentialBlockSize(MemoryUtil.memAddress((IntBuffer)minGridSize), MemoryUtil.memAddress((IntBuffer)blockSize), func, MemoryUtil.memAddressSafe((Pointer)blockSizeToDynamicSMemSize), dynamicSMemSize, blockSizeLimit);
    }

    public static int ncuOccupancyMaxPotentialBlockSizeWithFlags(long minGridSize, long blockSize, long func, long blockSizeToDynamicSMemSize, long dynamicSMemSize, int blockSizeLimit, int flags) {
        long __functionAddress = Functions.OccupancyMaxPotentialBlockSizeWithFlags;
        if (Checks.CHECKS) {
            Checks.check((long)func);
        }
        return JNI.callPPPPPI((long)minGridSize, (long)blockSize, (long)func, (long)blockSizeToDynamicSMemSize, (long)dynamicSMemSize, (int)blockSizeLimit, (int)flags, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuOccupancyMaxPotentialBlockSizeWithFlags(@NativeType(value="int *") IntBuffer minGridSize, @NativeType(value="int *") IntBuffer blockSize, @NativeType(value="CUfunction") long func, @NativeType(value="size_t (*) (int)") CUoccupancyB2DSizeI blockSizeToDynamicSMemSize, @NativeType(value="size_t") long dynamicSMemSize, int blockSizeLimit, @NativeType(value="unsigned int") int flags) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)minGridSize, (int)1);
            Checks.check((Buffer)blockSize, (int)1);
        }
        return CU65.ncuOccupancyMaxPotentialBlockSizeWithFlags(MemoryUtil.memAddress((IntBuffer)minGridSize), MemoryUtil.memAddress((IntBuffer)blockSize), func, blockSizeToDynamicSMemSize.address(), dynamicSMemSize, blockSizeLimit, flags);
    }

    public static final class Functions {
        public static final long OccupancyMaxActiveBlocksPerMultiprocessor = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuOccupancyMaxActiveBlocksPerMultiprocessor");
        public static final long OccupancyMaxActiveBlocksPerMultiprocessorWithFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags");
        public static final long OccupancyMaxPotentialBlockSize = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuOccupancyMaxPotentialBlockSize");
        public static final long OccupancyMaxPotentialBlockSizeWithFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuOccupancyMaxPotentialBlockSizeWithFlags");

        private Functions() {
        }
    }
}

