/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkKeyboard;
import org.lwjgl.nuklear.NkMouse;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_input")
public class NkInput
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KEYBOARD;
    public static final int MOUSE;

    public NkInput(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkInput.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_keyboard")
    public NkKeyboard keyboard() {
        return NkInput.nkeyboard(this.address());
    }

    @NativeType(value="struct nk_mouse")
    public NkMouse mouse() {
        return NkInput.nmouse(this.address());
    }

    public static NkInput malloc() {
        return (NkInput)NkInput.wrap(NkInput.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkInput calloc() {
        return (NkInput)NkInput.wrap(NkInput.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkInput create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkInput)NkInput.wrap(NkInput.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkInput create(long address) {
        return (NkInput)NkInput.wrap(NkInput.class, (long)address);
    }

    @Nullable
    public static NkInput createSafe(long address) {
        return address == 0L ? null : (NkInput)NkInput.wrap(NkInput.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkInput.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkInput.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkInput.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkInput.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkInput.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkInput.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkInput.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NkInput mallocStack() {
        return NkInput.mallocStack(MemoryStack.stackGet());
    }

    public static NkInput callocStack() {
        return NkInput.callocStack(MemoryStack.stackGet());
    }

    public static NkInput mallocStack(MemoryStack stack) {
        return (NkInput)NkInput.wrap(NkInput.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkInput callocStack(MemoryStack stack) {
        return (NkInput)NkInput.wrap(NkInput.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkInput.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkInput.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkInput.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkInput.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static NkKeyboard nkeyboard(long struct) {
        return NkKeyboard.create(struct + (long)KEYBOARD);
    }

    public static NkMouse nmouse(long struct) {
        return NkMouse.create(struct + (long)MOUSE);
    }

    static {
        Struct.Layout layout = NkInput.__struct((Struct.Member[])new Struct.Member[]{NkInput.__member((int)NkKeyboard.SIZEOF, (int)NkKeyboard.ALIGNOF), NkInput.__member((int)NkMouse.SIZEOF, (int)NkMouse.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KEYBOARD = layout.offsetof(0);
        MOUSE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkInput, Buffer>
    implements NativeResource {
        private static final NkInput ELEMENT_FACTORY = NkInput.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkInput getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_keyboard")
        public NkKeyboard keyboard() {
            return NkInput.nkeyboard(this.address());
        }

        @NativeType(value="struct nk_mouse")
        public NkMouse mouse() {
            return NkInput.nmouse(this.address());
        }
    }
}

