"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("core-js/modules/es.typed-array.set.js");

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryService {
  constructor(client) {
    _defineProperty(this, "client", void 0);

    _defineProperty(this, "describeQueryInternal", async (request, format, responseFormat) => {
      try {
        const queryRequest = {
          query: request.body.query
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        const queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        console.log(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });

    _defineProperty(this, "describeSQLQuery", async request => {
      return this.describeQueryInternal(request, 'sql.sqlQuery', 'json');
    });

    _defineProperty(this, "describePPLQuery", async request => {
      return this.describeQueryInternal(request, 'sql.pplQuery', 'json');
    });

    _defineProperty(this, "describeSQLCsv", async request => {
      return this.describeQueryInternal(request, 'sql.sqlCsv', null);
    });

    _defineProperty(this, "describePPLCsv", async request => {
      return this.describeQueryInternal(request, 'sql.pplCsv', null);
    });

    _defineProperty(this, "describeSQLJson", async request => {
      return this.describeQueryInternal(request, 'sql.sqlJson', 'json');
    });

    _defineProperty(this, "describePPLJson", async request => {
      return this.describeQueryInternal(request, 'sql.pplJson', 'json');
    });

    _defineProperty(this, "describeSQLText", async request => {
      return this.describeQueryInternal(request, 'sql.sqlText', null);
    });

    _defineProperty(this, "describePPLText", async request => {
      return this.describeQueryInternal(request, 'sql.pplText', null);
    });

    this.client = client;
  }

}

exports.default = QueryService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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