"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildConfig = void 0;

var _lodash = require("lodash");

var _operators = require("rxjs/operators");

var _createConfig = require("./createConfig");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const buildConfig = async (initContext, core, logger) => {
  const config$ = initContext.config.create();
  const serverInfo = core.http.getServerInfo();
  const osdConfig = {
    server: {
      basePath: core.http.basePath.serverBasePath,
      host: serverInfo.hostname,
      name: serverInfo.name,
      port: serverInfo.port,
      protocol: serverInfo.protocol
    }
  };
  const reportingConfig$ = (0, _createConfig.createConfig$)(core, config$, logger);
  const reportingConfig = await reportingConfig$.pipe((0, _operators.first)()).toPromise();
  return {
    get: (...keys) => (0, _lodash.get)(reportingConfig, keys.join('.'), null),
    osdConfig: {
      get: (...keys) => (0, _lodash.get)(osdConfig, keys.join('.'), null)
    }
  };
};

exports.buildConfig = buildConfig;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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