"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_PREFIX_DICT = exports.TRIGGER_TYPE_DICT = exports.REPORT_STATE_DICT = exports.REPORT_SOURCE_DICT = exports.REPORT_FORMAT_DICT = exports.BACKEND_TRIGGER_TYPE = exports.BACKEND_REPORT_STATE = exports.BACKEND_REPORT_SOURCE = exports.BACKEND_REPORT_FORMAT = exports.BACKEND_DELIVERY_FORMAT = void 0;

var _constants = require("../routes/utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let BACKEND_DELIVERY_FORMAT;
exports.BACKEND_DELIVERY_FORMAT = BACKEND_DELIVERY_FORMAT;

(function (BACKEND_DELIVERY_FORMAT) {
  BACKEND_DELIVERY_FORMAT["linkOnly"] = "LinkOnly";
  BACKEND_DELIVERY_FORMAT["attachment"] = "Attachment";
  BACKEND_DELIVERY_FORMAT["embedded"] = "Embedded";
})(BACKEND_DELIVERY_FORMAT || (exports.BACKEND_DELIVERY_FORMAT = BACKEND_DELIVERY_FORMAT = {}));

let BACKEND_REPORT_SOURCE;
exports.BACKEND_REPORT_SOURCE = BACKEND_REPORT_SOURCE;

(function (BACKEND_REPORT_SOURCE) {
  BACKEND_REPORT_SOURCE["dashboard"] = "Dashboard";
  BACKEND_REPORT_SOURCE["visualization"] = "Visualization";
  BACKEND_REPORT_SOURCE["savedSearch"] = "SavedSearch";
  BACKEND_REPORT_SOURCE["notebook"] = "Notebook";
})(BACKEND_REPORT_SOURCE || (exports.BACKEND_REPORT_SOURCE = BACKEND_REPORT_SOURCE = {}));

let BACKEND_REPORT_STATE;
exports.BACKEND_REPORT_STATE = BACKEND_REPORT_STATE;

(function (BACKEND_REPORT_STATE) {
  BACKEND_REPORT_STATE["scheduled"] = "Scheduled";
  BACKEND_REPORT_STATE["executing"] = "Executing";
  BACKEND_REPORT_STATE["success"] = "Success";
  BACKEND_REPORT_STATE["failed"] = "Failed";
})(BACKEND_REPORT_STATE || (exports.BACKEND_REPORT_STATE = BACKEND_REPORT_STATE = {}));

let BACKEND_REPORT_FORMAT;
exports.BACKEND_REPORT_FORMAT = BACKEND_REPORT_FORMAT;

(function (BACKEND_REPORT_FORMAT) {
  BACKEND_REPORT_FORMAT["pdf"] = "Pdf";
  BACKEND_REPORT_FORMAT["png"] = "Png";
  BACKEND_REPORT_FORMAT["csv"] = "Csv";
})(BACKEND_REPORT_FORMAT || (exports.BACKEND_REPORT_FORMAT = BACKEND_REPORT_FORMAT = {}));

let BACKEND_TRIGGER_TYPE;
exports.BACKEND_TRIGGER_TYPE = BACKEND_TRIGGER_TYPE;

(function (BACKEND_TRIGGER_TYPE) {
  BACKEND_TRIGGER_TYPE["download"] = "Download";
  BACKEND_TRIGGER_TYPE["onDemand"] = "OnDemand";
  BACKEND_TRIGGER_TYPE["cronSchedule"] = "CronSchedule";
  BACKEND_TRIGGER_TYPE["intervalSchedule"] = "IntervalSchedule";
})(BACKEND_TRIGGER_TYPE || (exports.BACKEND_TRIGGER_TYPE = BACKEND_TRIGGER_TYPE = {}));

const REPORT_STATE_DICT = {
  [_constants.REPORT_STATE.pending]: BACKEND_REPORT_STATE.executing,
  [_constants.REPORT_STATE.error]: BACKEND_REPORT_STATE.failed,
  [_constants.REPORT_STATE.shared]: BACKEND_REPORT_STATE.success,
  [_constants.REPORT_STATE.created]: BACKEND_REPORT_STATE.success
};
exports.REPORT_STATE_DICT = REPORT_STATE_DICT;
const REPORT_SOURCE_DICT = {
  [_constants.REPORT_TYPE.dashboard]: BACKEND_REPORT_SOURCE.dashboard,
  [_constants.REPORT_TYPE.visualization]: BACKEND_REPORT_SOURCE.visualization,
  [_constants.REPORT_TYPE.savedSearch]: BACKEND_REPORT_SOURCE.savedSearch,
  [_constants.REPORT_TYPE.notebook]: BACKEND_REPORT_SOURCE.notebook
};
exports.REPORT_SOURCE_DICT = REPORT_SOURCE_DICT;
const REPORT_FORMAT_DICT = {
  [_constants.FORMAT.csv]: BACKEND_REPORT_FORMAT.csv,
  [_constants.FORMAT.pdf]: BACKEND_REPORT_FORMAT.pdf,
  [_constants.FORMAT.png]: BACKEND_REPORT_FORMAT.png
};
exports.REPORT_FORMAT_DICT = REPORT_FORMAT_DICT;
const TRIGGER_TYPE_DICT = {
  [_constants.TRIGGER_TYPE.schedule]: [BACKEND_TRIGGER_TYPE.cronSchedule, BACKEND_TRIGGER_TYPE.intervalSchedule],
  [_constants.TRIGGER_TYPE.onDemand]: [BACKEND_TRIGGER_TYPE.onDemand, BACKEND_TRIGGER_TYPE.download]
};
exports.TRIGGER_TYPE_DICT = TRIGGER_TYPE_DICT;
const URL_PREFIX_DICT = {
  [BACKEND_REPORT_SOURCE.dashboard]: '/app/dashboards#/view/',
  [BACKEND_REPORT_SOURCE.savedSearch]: '/app/discover#/view/',
  [BACKEND_REPORT_SOURCE.visualization]: '/app/visualize#/edit/',
  [BACKEND_REPORT_SOURCE.notebook]: '/app/notebooks-dashboards?view=output_only#/'
};
exports.URL_PREFIX_DICT = URL_PREFIX_DICT;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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