/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.ClusterStatus;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.SimplePostTool;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.noggit.CharArr;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZookeeperInfoHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    private static final String PARAM_DETAIL = "detail";
    private final CoreContainer cores;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern endsWithDigits = Pattern.compile("^(\\D*)(\\d{1,7}?)$");
    private PagedCollectionSupport pagingSupport;

    public ZookeeperInfoHandler(CoreContainer cc) {
        this.cores = cc;
    }

    @Override
    public String getDescription() {
        return "Fetch Zookeeper contents";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        SolrParams params = request.getParams();
        String path = params.get("path", "");
        String detail = params.get(PARAM_DETAIL, "false");
        if ("/security.json".equalsIgnoreCase(path) && "true".equalsIgnoreCase(detail)) {
            return PermissionNameProvider.Name.SECURITY_READ_PERM;
        }
        return PermissionNameProvider.Name.ZK_READ_PERM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String filter;
        SolrParams params = req.getParams();
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("wt", "raw");
        map.put("omitHeader", "true");
        req.setParams(SolrParams.wrapDefaults((SolrParams)new MapSolrParams(map), (SolrParams)params));
        ZookeeperInfoHandler zookeeperInfoHandler = this;
        synchronized (zookeeperInfoHandler) {
            if (this.pagingSupport == null) {
                this.pagingSupport = new PagedCollectionSupport();
                ZkController zkController = this.cores.getZkController();
                if (zkController != null) {
                    zkController.addOnReconnectListener(this.pagingSupport);
                }
            }
        }
        String path = params.get("path");
        if (params.get("addr") != null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal parameter \"addr\"");
        }
        String detailS = params.get(PARAM_DETAIL);
        boolean detail = detailS != null && detailS.equals("true");
        String dumpS = params.get("dump");
        boolean dump = dumpS != null && dumpS.equals("true");
        int start = params.getInt("start", 0);
        int rows = params.getInt("rows", -1);
        String filterType = params.get("filterType");
        if (filterType != null && (filterType = filterType.trim().toLowerCase(Locale.ROOT)).length() == 0) {
            filterType = null;
        }
        FilterType type = filterType != null ? FilterType.valueOf(filterType) : FilterType.none;
        String string = filter = type != FilterType.none ? params.get("filter") : null;
        if (filter != null && (filter = filter.trim()).length() == 0) {
            filter = null;
        }
        ZKPrinter printer = new ZKPrinter(this.cores.getZkController());
        printer.detail = detail;
        printer.dump = dump;
        boolean isGraphView = "graph".equals(params.get("view"));
        printer.page = isGraphView && "/clusterstate.json".equals(path) ? new PageOfCollections(start, rows, type, filter) : null;
        printer.pagingSupport = this.pagingSupport;
        try {
            printer.print(path);
        }
        finally {
            printer.close();
        }
        rsp.getValues().add("content", (Object)printer);
    }

    static class ZKPrinter
    implements ContentStream {
        static boolean FULLPATH_DEFAULT = false;
        boolean indent = true;
        boolean fullpath = FULLPATH_DEFAULT;
        boolean detail = false;
        boolean dump = false;
        String keeperAddr;
        final SimplePostTool.BAOS baos = new SimplePostTool.BAOS();
        final Writer out = new OutputStreamWriter((OutputStream)this.baos, StandardCharsets.UTF_8);
        SolrZkClient zkClient;
        PageOfCollections page;
        PagedCollectionSupport pagingSupport;
        ZkController zkController;

        public ZKPrinter(ZkController controller) throws IOException {
            this.zkController = controller;
            this.keeperAddr = controller.getZkServerAddress();
            this.zkClient = controller.getZkClient();
        }

        public void close() {
            try {
                this.out.flush();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        void print(String path) throws IOException {
            int idx;
            String parent;
            if (this.zkClient == null) {
                return;
            }
            if (path == null) {
                path = "/";
            } else if ((path = path.trim()).length() == 0) {
                path = "/";
            }
            if (path.endsWith("/") && path.length() > 1) {
                path = path.substring(0, path.length() - 1);
            }
            String string = parent = (idx = path.lastIndexOf(47)) >= 0 ? path.substring(0, idx) : path;
            if (parent.length() == 0) {
                parent = "/";
            }
            CharArr chars = new CharArr();
            JSONWriter json = new JSONWriter(chars, 2);
            json.startObject();
            if (this.detail) {
                if (!this.printZnode(json, path)) {
                    return;
                }
                json.writeValueSeparator();
            }
            json.writeString("tree");
            json.writeNameSeparator();
            json.startArray();
            if (!this.printTree(json, path)) {
                return;
            }
            json.endArray();
            json.endObject();
            this.out.write(chars.toString());
        }

        void writeError(int code, String msg) throws IOException {
            throw new SolrException(SolrException.ErrorCode.getErrorCode((int)code), msg);
        }

        boolean printTree(JSONWriter json, String path) throws IOException {
            String label = path;
            if (!this.fullpath) {
                int idx = path.lastIndexOf(47);
                label = idx > 0 ? path.substring(idx + 1) : path;
            }
            json.startObject();
            this.writeKeyValue(json, "text", label, true);
            json.writeValueSeparator();
            json.writeString("a_attr");
            json.writeNameSeparator();
            json.startObject();
            String href = "admin/zookeeper?detail=true&path=" + URLEncoder.encode(path, "UTF-8");
            this.writeKeyValue(json, "href", href, true);
            json.endObject();
            Stat stat = new Stat();
            try {
                byte[] data = this.zkClient.getData(path, null, stat, true);
                if (stat.getEphemeralOwner() != 0L) {
                    this.writeKeyValue(json, "ephemeral", true, false);
                    this.writeKeyValue(json, "version", stat.getVersion(), false);
                }
                if (this.dump) {
                    json.writeValueSeparator();
                    this.printZnode(json, path);
                }
            }
            catch (IllegalArgumentException e) {
                this.writeKeyValue(json, "warning", "(path gone)", false);
            }
            catch (KeeperException e) {
                this.writeKeyValue(json, "warning", e.toString(), false);
                log.warn("Keeper Exception", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.writeKeyValue(json, "warning", e.toString(), false);
                log.warn("InterruptedException", (Throwable)e);
            }
            if (stat.getNumChildren() > 0) {
                json.writeValueSeparator();
                if (this.indent) {
                    json.indent();
                }
                json.writeString("children");
                json.writeNameSeparator();
                json.startArray();
                try {
                    List children = this.zkClient.getChildren(path, null, true);
                    Collections.sort(children);
                    boolean first = true;
                    for (String child : children) {
                        String childPath;
                        if (!first) {
                            json.writeValueSeparator();
                        }
                        if (!this.printTree(json, childPath = path + (path.endsWith("/") ? "" : "/") + child)) {
                            return false;
                        }
                        first = false;
                    }
                }
                catch (KeeperException e) {
                    this.writeError(500, e.toString());
                    return false;
                }
                catch (InterruptedException e) {
                    this.writeError(500, e.toString());
                    return false;
                }
                catch (IllegalArgumentException e) {
                    json.writeString("(children gone)");
                }
                json.endArray();
            }
            json.endObject();
            return true;
        }

        String time(long ms) {
            return new Date(ms).toString() + " (" + ms + ")";
        }

        public void writeKeyValue(JSONWriter json, String k, Object v, boolean isFirst) {
            if (!isFirst) {
                json.writeValueSeparator();
            }
            if (this.indent) {
                json.indent();
            }
            json.writeString(k);
            json.writeNameSeparator();
            json.write(v);
        }

        boolean printZnode(JSONWriter json, String path) throws IOException {
            try {
                String dataStr = null;
                String dataStrErr = null;
                Stat stat = new Stat();
                byte[] data = this.zkClient.getData(path, null, stat, true);
                if (null != data) {
                    try {
                        dataStr = new BytesRef(data).utf8ToString();
                    }
                    catch (Exception e) {
                        dataStrErr = "data is not parsable as a utf8 String: " + e.toString();
                    }
                }
                if (this.page != null) {
                    Map clusterstateJsonMap = null;
                    if (dataStr != null) {
                        try {
                            clusterstateJsonMap = (Map)Utils.fromJSONString((String)dataStr);
                        }
                        catch (Exception e) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to parse /clusterstate.json from ZooKeeper due to: " + e, (Throwable)e);
                        }
                    } else {
                        clusterstateJsonMap = Utils.makeMap((Object[])new Object[0]);
                    }
                    this.page = this.pagingSupport.fetchPage(this.page, this.zkClient);
                    boolean applyStatusFilter = this.page.filterType == FilterType.status && this.page.filter != null;
                    ArrayList<String> matchesStatusFilter = applyStatusFilter ? new ArrayList<String>() : null;
                    ClusterState cs = this.zkController.getZkStateReader().getClusterState();
                    Set liveNodes = applyStatusFilter ? cs.getLiveNodes() : null;
                    TreeMap<String, Map<String, Object>> collectionStates = new TreeMap<String, Map<String, Object>>(this.pagingSupport);
                    for (String collection : this.page.selected) {
                        Object collectionState = clusterstateJsonMap.get(collection);
                        if (collectionState != null) {
                            if (applyStatusFilter) {
                                if (!this.page.matchesStatusFilter((Map)collectionState, liveNodes)) continue;
                                matchesStatusFilter.add(collection);
                                collectionStates.put(collection, ClusterStatus.postProcessCollectionJSON((Map)collectionState));
                                continue;
                            }
                            collectionStates.put(collection, ClusterStatus.postProcessCollectionJSON((Map)collectionState));
                            continue;
                        }
                        DocCollection dc = cs.getCollectionOrNull(collection);
                        if (dc == null) continue;
                        Object v = collectionState = dc.isPerReplicaState() ? Utils.fromJSONString((String)Utils.toJSONString((Object)dc)) : dc.getProperties();
                        if (applyStatusFilter) {
                            if (!this.page.matchesStatusFilter((Map)collectionState, liveNodes)) continue;
                            matchesStatusFilter.add(collection);
                            collectionStates.put(collection, ClusterStatus.postProcessCollectionJSON((Map)collectionState));
                            continue;
                        }
                        collectionStates.put(collection, ClusterStatus.postProcessCollectionJSON((Map)collectionState));
                    }
                    if (applyStatusFilter) {
                        this.page.selectPage(matchesStatusFilter);
                        TreeMap map = new TreeMap(this.pagingSupport);
                        for (String next : this.page.selected) {
                            map.put(next, collectionStates.get(next));
                        }
                        collectionStates = map;
                    }
                    if (collectionStates != null) {
                        CharArr out = new CharArr();
                        new JSONWriter(out, 2).write(collectionStates);
                        dataStr = out.toString();
                    }
                }
                json.writeString("znode");
                json.writeNameSeparator();
                json.startObject();
                this.writeKeyValue(json, "path", path, true);
                json.writeValueSeparator();
                json.writeString("prop");
                json.writeNameSeparator();
                json.startObject();
                this.writeKeyValue(json, "version", stat.getVersion(), true);
                this.writeKeyValue(json, "aversion", stat.getAversion(), false);
                this.writeKeyValue(json, "children_count", stat.getNumChildren(), false);
                this.writeKeyValue(json, "ctime", this.time(stat.getCtime()), false);
                this.writeKeyValue(json, "cversion", stat.getCversion(), false);
                this.writeKeyValue(json, "czxid", stat.getCzxid(), false);
                this.writeKeyValue(json, "ephemeralOwner", stat.getEphemeralOwner(), false);
                this.writeKeyValue(json, "mtime", this.time(stat.getMtime()), false);
                this.writeKeyValue(json, "mzxid", stat.getMzxid(), false);
                this.writeKeyValue(json, "pzxid", stat.getPzxid(), false);
                this.writeKeyValue(json, "dataLength", stat.getDataLength(), false);
                if (null != dataStrErr) {
                    this.writeKeyValue(json, "dataNote", dataStrErr, false);
                }
                json.endObject();
                if (null != dataStr) {
                    this.writeKeyValue(json, "data", dataStr, false);
                }
                if (this.page != null) {
                    this.writeKeyValue(json, "paging", this.page.getPagingHeader(), false);
                }
                json.endObject();
            }
            catch (KeeperException e) {
                this.writeError(500, e.toString());
                return false;
            }
            catch (InterruptedException e) {
                this.writeError(500, e.toString());
                return false;
            }
            return true;
        }

        public String getName() {
            return null;
        }

        public String getSourceInfo() {
            return null;
        }

        public String getContentType() {
            return JSONResponseWriter.CONTENT_TYPE_JSON_UTF8;
        }

        public Long getSize() {
            return null;
        }

        public InputStream getStream() throws IOException {
            return new ByteBufferInputStream(this.baos.getByteBuffer());
        }

        public Reader getReader() throws IOException {
            return null;
        }
    }

    static final class PagedCollectionSupport
    implements Watcher,
    Comparator<String>,
    OnReconnect {
        private List<String> cachedCollections;

        PagedCollectionSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            PagedCollectionSupport pagedCollectionSupport = this;
            synchronized (pagedCollectionSupport) {
                this.cachedCollections = null;
            }
        }

        private synchronized List<String> getCollections(SolrZkClient zkClient) throws KeeperException, InterruptedException {
            if (this.cachedCollections == null) {
                this.cachedCollections = new ArrayList<String>();
                List fromZk = zkClient.getChildren("/collections", (Watcher)this, true);
                if (fromZk != null) {
                    this.cachedCollections.addAll(fromZk);
                }
                Collections.sort(this.cachedCollections, this);
            }
            return this.cachedCollections;
        }

        public PageOfCollections fetchPage(PageOfCollections page, SolrZkClient zkClient) throws KeeperException, InterruptedException {
            List<String> children = this.getCollections(zkClient);
            page.selected = children;
            if (page.start == 0 && page.rows == -1 && page.filter == null && children.size() > 10) {
                page.rows = 20;
                page.start = 0;
            }
            if (page.filterType == FilterType.name && page.filter != null) {
                children = page.applyNameFilter(children);
            }
            if (page.filterType != FilterType.status) {
                page.selectPage(children);
            }
            return page;
        }

        @Override
        public int compare(String left, String right) {
            String rightGroup1;
            String leftGroup1;
            Matcher rightMatcher;
            if (left == null) {
                return -1;
            }
            if (left.equals(right)) {
                return 0;
            }
            Matcher leftMatcher = endsWithDigits.matcher(left);
            if (leftMatcher.matches() && (rightMatcher = endsWithDigits.matcher(right)).matches() && (leftGroup1 = leftMatcher.group(1)).equals(rightGroup1 = rightMatcher.group(1))) {
                int rightGroup2;
                int leftGroup2 = Integer.parseInt(leftMatcher.group(2));
                return leftGroup2 > (rightGroup2 = Integer.parseInt(rightMatcher.group(2))) ? 1 : (leftGroup2 == rightGroup2 ? 0 : -1);
            }
            return left.compareTo(right);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void command() {
            PagedCollectionSupport pagedCollectionSupport = this;
            synchronized (pagedCollectionSupport) {
                this.cachedCollections = null;
            }
        }
    }

    static final class PageOfCollections {
        List<String> selected;
        int numFound = 0;
        int start = 0;
        int rows = -1;
        FilterType filterType;
        String filter;

        PageOfCollections(int start, int rows, FilterType filterType, String filter) {
            this.start = start;
            this.rows = rows;
            this.filterType = filterType;
            this.filter = filter;
        }

        void selectPage(List<String> collections) {
            this.numFound = collections.size();
            this.selected = collections;
            if (this.rows > 0) {
                if (this.start > this.numFound) {
                    this.start = 0;
                }
                int lastIndex = Math.min(this.start + this.rows, this.numFound);
                if (this.start > 0 || lastIndex < this.numFound) {
                    this.selected = collections.subList(this.start, lastIndex);
                }
            }
        }

        List<String> applyNameFilter(List<String> collections) {
            String regexFilter;
            if (this.filterType != FilterType.name || this.filter == null) {
                return collections;
            }
            String string = regexFilter = !this.filter.endsWith(".*") && this.filter.endsWith("*") ? this.filter.substring(0, this.filter.length() - 1) + ".*" : this.filter;
            if (!regexFilter.startsWith("(?i)")) {
                regexFilter = "(?i)" + regexFilter;
            }
            Pattern filterRegex = Pattern.compile(regexFilter);
            ArrayList<String> filtered = new ArrayList<String>();
            for (String next : collections) {
                if (!this.matches(filterRegex, next)) continue;
                filtered.add(next);
            }
            return filtered;
        }

        final boolean matchesStatusFilter(Map<String, Object> collectionState, Set<String> liveNodes) {
            if (this.filterType != FilterType.status || this.filter == null || this.filter.length() == 0) {
                return true;
            }
            boolean isHealthy = true;
            boolean hasDownedShard = false;
            boolean replicaInRecovery = false;
            Map shards = (Map)collectionState.get("shards");
            for (Object o : shards.values()) {
                boolean hasActive = false;
                Map shard = (Map)o;
                Map replicas = (Map)shard.get("replicas");
                for (Object value : replicas.values()) {
                    Map replicaState = (Map)value;
                    Replica.State coreState = Replica.State.getState((String)((String)replicaState.get("state")));
                    String nodeName = (String)replicaState.get("node_name");
                    if (!liveNodes.contains(nodeName)) {
                        coreState = Replica.State.DOWN;
                    }
                    if (coreState == Replica.State.ACTIVE) {
                        hasActive = true;
                        continue;
                    }
                    if (coreState == Replica.State.RECOVERING) {
                        replicaInRecovery = true;
                    }
                    isHealthy = false;
                }
                if (hasActive) continue;
                hasDownedShard = true;
            }
            if ("healthy".equals(this.filter)) {
                return isHealthy;
            }
            if ("degraded".equals(this.filter)) {
                return !hasDownedShard && !isHealthy;
            }
            if ("downed_shard".equals(this.filter)) {
                return hasDownedShard;
            }
            if (Replica.State.getState((String)this.filter) == Replica.State.RECOVERING) {
                return !isHealthy && replicaInRecovery;
            }
            return true;
        }

        final boolean matches(Pattern filter, String collName) {
            return filter.matcher(collName).matches();
        }

        String getPagingHeader() {
            return this.start + "|" + this.rows + "|" + this.numFound + "|" + (this.filterType != null ? this.filterType.toString() : "") + "|" + (this.filter != null ? this.filter : "");
        }

        public String toString() {
            return this.getPagingHeader();
        }
    }

    static enum FilterType {
        none,
        name,
        status;

    }
}

