/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.util.Holder;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.handler.sql.SolrSchema;
import org.apache.solr.handler.sql.functions.ArrayContainsAll;
import org.apache.solr.handler.sql.functions.ArrayContainsAny;

public class CalciteSolrDriver
extends Driver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:calcitesolr:";
    public static CalciteSolrDriver INSTANCE = new CalciteSolrDriver();
    private SolrClientCache solrClientCache;

    private CalciteSolrDriver() {
    }

    static void subQueryThreshold(Holder<SqlToRelConverter.Config> configHolder) {
        configHolder.accept(config -> config.withInSubQueryThreshold(Integer.MAX_VALUE));
    }

    static void relBuilderSimplify(Holder<Boolean> configHolder) {
        configHolder.accept(config -> false);
    }

    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Hook.SQL2REL_CONVERTER_CONFIG_BUILDER.addThread(CalciteSolrDriver::subQueryThreshold);
        Hook.REL_BUILDER_SIMPLIFY.addThread(CalciteSolrDriver::relBuilderSimplify);
        Connection connection = super.connect(url, info);
        CalciteConnection calciteConnection = (CalciteConnection)connection;
        this.registerUDFs();
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        String schemaName = info.getProperty("zk");
        if (schemaName == null) {
            throw new SQLException("zk must be set");
        }
        SolrSchema solrSchema = new SolrSchema(info, this.solrClientCache);
        rootSchema.add(schemaName, (Schema)solrSchema);
        calciteConnection.setSchema(schemaName);
        return calciteConnection;
    }

    private void registerUDFs() {
        SqlStdOperatorTable stdOpTab = SqlStdOperatorTable.instance();
        stdOpTab.register((SqlOperator)new ArrayContainsAll());
        stdOpTab.register((SqlOperator)new ArrayContainsAny());
    }

    public void setSolrClientCache(SolrClientCache solrClientCache) {
        this.solrClientCache = solrClientCache;
    }

    static {
        INSTANCE.register();
    }
}

