/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CheckHits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTestUtil;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LuceneTestCase;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class BaseExplanationTestCase
extends LuceneTestCase {
    protected static IndexSearcher searcher;
    protected static IndexReader reader;
    protected static Directory directory;
    protected static Analyzer analyzer;
    public static final String KEY = "KEY";
    public static final String FIELD = "field";
    public static final String ALTFIELD = "alt";
    protected static final String[] docFields;

    @AfterClass
    public static void afterClassTestExplanations() throws Exception {
        searcher = null;
        reader.close();
        reader = null;
        directory.close();
        directory = null;
        analyzer.close();
        analyzer = null;
    }

    @BeforeClass
    public static void beforeClassTestExplanations() throws Exception {
        directory = BaseExplanationTestCase.newDirectory();
        analyzer = new MockAnalyzer(BaseExplanationTestCase.random());
        try (RandomIndexWriter writer = new RandomIndexWriter(BaseExplanationTestCase.random(), directory, BaseExplanationTestCase.newIndexWriterConfig(analyzer).setMergePolicy((MergePolicy)BaseExplanationTestCase.newLogMergePolicy()));){
            for (int i = 0; i < docFields.length; ++i) {
                writer.addDocument(BaseExplanationTestCase.createDoc(i));
            }
            reader = writer.getReader();
            searcher = BaseExplanationTestCase.newSearcher(reader);
        }
    }

    public static Document createDoc(int index) {
        Document doc = new Document();
        doc.add((IndexableField)BaseExplanationTestCase.newStringField(KEY, "" + index, Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField(KEY, new BytesRef((CharSequence)("" + index))));
        Field f = BaseExplanationTestCase.newTextField(FIELD, docFields[index], Field.Store.NO);
        doc.add((IndexableField)f);
        doc.add((IndexableField)BaseExplanationTestCase.newTextField(ALTFIELD, docFields[index], Field.Store.NO));
        return doc;
    }

    public void qtest(Query q, int[] expDocNrs) throws Exception {
        if (BaseExplanationTestCase.random().nextBoolean()) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.add(q, BooleanClause.Occur.SHOULD);
            bq.add((Query)new TermQuery(new Term("NEVER", "MATCH")), BooleanClause.Occur.SHOULD);
            q = bq.build();
        }
        CheckHits.checkHitCollector(BaseExplanationTestCase.random(), q, FIELD, searcher, expDocNrs);
    }

    public void bqtest(Query q, int[] expDocNrs) throws Exception {
        this.qtest(this.reqB(q), expDocNrs);
        this.qtest(this.optB(q), expDocNrs);
    }

    protected Query matchTheseItems(int[] terms) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        for (int term : terms) {
            query.add(new BooleanClause((Query)new TermQuery(new Term(KEY, "" + term)), BooleanClause.Occur.SHOULD));
        }
        return query.build();
    }

    public static Term[] ta(String[] s) {
        Term[] t = new Term[s.length];
        for (int i = 0; i < s.length; ++i) {
            t[i] = new Term(FIELD, s[i]);
        }
        return t;
    }

    public SpanQuery st(String s) {
        return SpanTestUtil.spanTermQuery(FIELD, s);
    }

    public SpanQuery snot(SpanQuery i, SpanQuery e) {
        return SpanTestUtil.spanNotQuery(i, e);
    }

    public SpanQuery sor(String s, String e) {
        return SpanTestUtil.spanOrQuery(FIELD, s, e);
    }

    public SpanQuery sor(SpanQuery s, SpanQuery e) {
        return SpanTestUtil.spanOrQuery(s, e);
    }

    public SpanQuery sor(String s, String m, String e) {
        return SpanTestUtil.spanOrQuery(FIELD, s, m, e);
    }

    public SpanQuery sor(SpanQuery s, SpanQuery m, SpanQuery e) {
        return SpanTestUtil.spanOrQuery(s, m, e);
    }

    public SpanQuery snear(String s, String e, int slop, boolean inOrder) {
        return this.snear(this.st(s), this.st(e), slop, inOrder);
    }

    public SpanQuery snear(SpanQuery s, SpanQuery e, int slop, boolean inOrder) {
        if (inOrder) {
            return SpanTestUtil.spanNearOrderedQuery(slop, s, e);
        }
        return SpanTestUtil.spanNearUnorderedQuery(slop, s, e);
    }

    public SpanQuery snear(String s, String m, String e, int slop, boolean inOrder) {
        return this.snear(this.st(s), this.st(m), this.st(e), slop, inOrder);
    }

    public SpanQuery snear(SpanQuery s, SpanQuery m, SpanQuery e, int slop, boolean inOrder) {
        if (inOrder) {
            return SpanTestUtil.spanNearOrderedQuery(slop, s, m, e);
        }
        return SpanTestUtil.spanNearUnorderedQuery(slop, s, m, e);
    }

    public SpanQuery sf(String s, int b) {
        return SpanTestUtil.spanFirstQuery(this.st(s), b);
    }

    public Query optB(Query q) throws Exception {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add(q, BooleanClause.Occur.SHOULD);
        bq.add((Query)new TermQuery(new Term("NEVER", "MATCH")), BooleanClause.Occur.MUST_NOT);
        return bq.build();
    }

    public Query reqB(Query q) throws Exception {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add(q, BooleanClause.Occur.MUST);
        bq.add((Query)new TermQuery(new Term(FIELD, "w1")), BooleanClause.Occur.SHOULD);
        return bq.build();
    }

    static {
        docFields = new String[]{"w1 w2 w3 w4 w5", "w1 w3 w2 w3 zz", "w1 xx w2 yy w3", "w1 w3 xx w2 yy w3 zz"};
    }
}

