/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.bruteforce;

import de.rub.nds.tlsattacker.attacks.bruteforce.GuessProvider;
import de.rub.nds.tlsattacker.attacks.bruteforce.GuessProviderType;

public class IncrementingGuessProvider
extends GuessProvider {
    private byte[] lastGuess = null;
    private int size = 0;

    public IncrementingGuessProvider() {
        super(GuessProviderType.INCREMENTING);
    }

    @Override
    public byte[] getGuess() {
        byte[] guess = this.getIncrementedGuess();
        return guess;
    }

    private byte[] getIncrementedGuess() {
        if (this.lastGuess == null) {
            this.lastGuess = new byte[this.size];
        } else {
            this.lastGuess = this.createdIncrementedAtPosition(this.lastGuess, 0);
            if (this.lastGuess == null) {
                ++this.size;
                this.lastGuess = new byte[this.size];
            }
        }
        return this.lastGuess;
    }

    private byte[] createdIncrementedAtPosition(byte[] array, int position) {
        if (array.length > position) {
            array[position] = (byte)(array[position] + 1);
            if (array[position] == 0) {
                return this.createdIncrementedAtPosition(array, position + 1);
            }
            return array;
        }
        return null;
    }
}

