/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension.keyshare;

import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.DragonFlyKeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import java.math.BigInteger;

public class DragonFlyKeyShareEntryParser
extends Parser<DragonFlyKeyShareEntry> {
    private NamedGroup group;

    public DragonFlyKeyShareEntryParser(byte[] array, NamedGroup group) {
        super(0, array);
        this.group = group;
    }

    @Override
    public DragonFlyKeyShareEntry parse() {
        if (this.group.isCurve()) {
            EllipticCurve curve = CurveFactory.getCurve(this.group);
            int elementLength = curve.getModulus().bitLength();
            byte[] rawPublicKey = this.parseByteArrayField(elementLength * 2 / 8);
            int scalarLength = this.parseIntField(1);
            BigInteger scalar = this.parseBigIntField(scalarLength);
            return new DragonFlyKeyShareEntry(rawPublicKey, scalarLength, scalar);
        }
        throw new UnsupportedOperationException("Non-Curves are currently not supported");
    }
}

