/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.Preparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExtensionPreparator<T extends ExtensionMessage>
extends Preparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExtensionMessage msg;
    private byte[] content;
    private final ExtensionSerializer<T> serializer;

    public ExtensionPreparator(Chooser chooser, T message, ExtensionSerializer<T> serializer) {
        super(chooser, message);
        this.msg = message;
        this.serializer = serializer;
    }

    @Override
    public final void prepare() {
        this.prepareExtensionType(this.msg);
        this.prepareExtensionContent();
        this.content = this.serializer.serializeExtensionContent();
        this.prepareExtensionLength(this.msg);
        this.prepareExtensionBytes(this.msg);
    }

    @Override
    public final void afterPrepare() {
        this.prepareExtensionType(this.msg);
        this.afterPrepareExtensionContent();
        this.content = this.serializer.serializeExtensionContent();
        this.prepareExtensionLength(this.msg);
        this.prepareExtensionBytes(this.msg);
    }

    public abstract void prepareExtensionContent();

    public void afterPrepareExtensionContent() {
    }

    private void prepareExtensionType(ExtensionMessage msg) {
        msg.setExtensionType(msg.getExtensionTypeConstant().getValue());
        LOGGER.debug("ExtensionType: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getExtensionType().getValue())));
    }

    private void prepareExtensionLength(ExtensionMessage msg) {
        msg.setExtensionLength(this.content.length);
        LOGGER.debug("ExtensionLength: " + msg.getExtensionLength().getValue());
    }

    private void prepareExtensionBytes(ExtensionMessage msg) {
        msg.setExtensionBytes(this.serializer.serialize());
        LOGGER.debug("ExtensionBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getExtensionBytes().getValue())));
    }
}

