/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper.model;

import java.util.TimeZone;
import org.traccar.model.Server;
import org.traccar.model.User;

public final class UserUtil {
    private UserUtil() {
    }

    public static String getDistanceUnit(Server server, User user) {
        return UserUtil.lookupStringAttribute(server, user, "distanceUnit", "km");
    }

    public static String getSpeedUnit(Server server, User user) {
        return UserUtil.lookupStringAttribute(server, user, "speedUnit", "kn");
    }

    public static String getVolumeUnit(Server server, User user) {
        return UserUtil.lookupStringAttribute(server, user, "volumeUnit", "ltr");
    }

    public static TimeZone getTimezone(Server server, User user) {
        String timezone = UserUtil.lookupStringAttribute(server, user, "timezone", null);
        return timezone != null ? TimeZone.getTimeZone(timezone) : TimeZone.getDefault();
    }

    private static String lookupStringAttribute(Server server, User user, String key, String defaultValue) {
        String serverPreference = server.getString(key);
        String userPreference = user.getString(key);
        String preference = server.getForceSettings() ? (serverPreference != null ? serverPreference : userPreference) : (userPreference != null ? userPreference : serverPreference);
        return preference != null ? preference : defaultValue;
    }
}

