/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.vcslinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.Date;

public class VcsFileRevisionWrapper
implements VcsFileRevision {
    private final VirtualFile myFile;
    private final Project myProject;
    private final VcsFileRevision myRevision;
    private boolean isContenLoaded = false;

    public VcsFileRevisionWrapper(VirtualFile file, Project project, VcsFileRevision revision) {
        this.myFile = file;
        this.myProject = project;
        this.myRevision = revision;
    }

    private synchronized void checkLoading() throws VcsException {
        if (!this.isContenLoaded) {
            this.myRevision.loadContent();
            this.isContenLoaded = true;
        }
    }

    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevision.getRevisionNumber();
    }

    public String getBranchName() {
        return this.myRevision.getBranchName();
    }

    public Date getRevisionDate() {
        return this.myRevision.getRevisionDate();
    }

    public String getAuthor() {
        return this.myRevision.getAuthor();
    }

    public String getCommitMessage() {
        return this.myRevision.getCommitMessage();
    }

    public void loadContent() throws VcsException {
        this.checkLoading();
    }

    public byte[] getContent() throws IOException {
        try {
            this.checkLoading();
        }
        catch (VcsException e) {
            throw new IOException("Content loading failed");
        }
        return this.myRevision.getContent();
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public Project getProject() {
        return this.myProject;
    }

    public String toString() {
        return String.valueOf(this.myRevision);
    }
}

