/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.ReadlineFlag;
import org.aesh.readline.action.ActionDecoder;
import org.aesh.readline.history.History;
import org.aesh.readline.history.InMemoryHistory;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.terminal.impl.WinSysTerminal;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;

public class PagingSupport {
    private static final EnumMap<ReadlineFlag, Integer> RED_PATTERN_READLINE_FLAGS = new EnumMap(ReadlineFlag.class);
    private final History searchHistory = new InMemoryHistory();
    private Paging paging;
    private final Connection connection;
    private final Readline readline;
    private StringBuilder outputCollector;
    private final boolean search;

    public PagingSupport(Connection connection, boolean search) {
        this(connection, null, search);
    }

    @Deprecated
    public PagingSupport(Connection connection, Readline readline, boolean search) {
        this.connection = connection;
        this.readline = readline;
        this.search = search;
        final Consumer<Size> consumer = connection.getSizeHandler();
        connection.setSizeHandler(new Consumer<Size>(){

            @Override
            public void accept(Size t) {
                if (consumer != null) {
                    consumer.accept(t);
                }
                if (PagingSupport.this.paging != null) {
                    PagingSupport.this.paging.redraw(t);
                }
            }
        });
    }

    public boolean isPagingOutputActive() {
        return this.paging != null && this.paging.paging;
    }

    public void reset() {
        this.outputCollector = null;
    }

    public void addContent(String content) {
        if (this.outputCollector == null) {
            this.outputCollector = new StringBuilder();
        }
        this.outputCollector.append(content);
    }

    private Connection getConnection() {
        return this.connection;
    }

    private Readline getReadline() {
        return this.readline == null ? new Readline() : this.readline;
    }

    private StringBuilder getOutputCollector() {
        return this.outputCollector;
    }

    private void clearScreen() {
        if (this.getConnection() != null) {
            this.getConnection().stdoutHandler().accept(ANSI.CLEAR_SCREEN);
        }
    }

    private void displayHightlighted(String pattern, String l) {
        int index = l.indexOf(pattern);
        while (index >= 0) {
            this.getConnection().write(l.substring(0, index));
            this.getConnection().write(ANSI.INVERT_BACKGROUND);
            this.getConnection().write(pattern);
            this.getConnection().write("\u001b[0m");
            l = l.substring(index + pattern.length());
            index = l.indexOf(pattern);
        }
        this.getConnection().write(l + Config.getLineSeparator());
    }

    public void printCollectedOutput() {
        if (this.getOutputCollector() == null || this.getOutputCollector().length() == 0) {
            return;
        }
        String line = this.getOutputCollector().toString();
        if (line.isEmpty()) {
            return;
        }
        if (this.search) {
            this.printAndSearchCollectedOuput(line);
        } else {
            this.printCollectedOutput(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printCollectedOutput(String line) {
        try {
            String[] lines = line.split("\\R", -1);
            int max = this.connection.size().getHeight();
            int currentLines = 0;
            int allLines = 0;
            while (allLines < lines.length) {
                if (currentLines > max - 2) {
                    try {
                        this.connection.write(ANSI.CURSOR_SAVE);
                        int percentage = allLines * 100 / lines.length;
                        this.connection.write("--More(" + percentage + "%)--");
                        Key k = this.read();
                        this.connection.write(ANSI.CURSOR_RESTORE);
                        this.connection.stdoutHandler().accept(ANSI.ERASE_LINE_FROM_CURSOR);
                        if (k == null) {
                            allLines = lines.length;
                            continue;
                        }
                        switch (k) {
                            case SPACE: {
                                currentLines = 0;
                                break;
                            }
                            case ENTER: 
                            case CTRL_M: {
                                --currentLines;
                                break;
                            }
                            case q: {
                                allLines = lines.length;
                            }
                        }
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(ex);
                    }
                }
                String l = lines[allLines];
                ++currentLines;
                if (++allLines == lines.length && l.isEmpty()) continue;
                this.connection.write(l + Config.getLineSeparator());
            }
        }
        finally {
            this.outputCollector = null;
        }
    }

    private void printAndSearchCollectedOuput(String line) {
        try {
            this.paging = new Paging(line, this.getConnection().size());
            while (this.paging.inWorkflow()) {
                if (this.paging.needPrompt()) {
                    try {
                        this.getConnection().write(ANSI.CURSOR_SAVE);
                        this.paging.drawPrompt();
                        Key k = this.read();
                        this.getConnection().write(ANSI.CURSOR_RESTORE);
                        this.getConnection().stdoutHandler().accept(ANSI.ERASE_LINE_FROM_CURSOR);
                        if (k == null) {
                            this.paging.exit();
                            continue;
                        }
                        switch (k) {
                            case SPACE: 
                            case PGDOWN_2: 
                            case PGDOWN: {
                                this.paging.pageDown();
                                break;
                            }
                            case BACKSLASH: 
                            case PGUP_2: 
                            case PGUP: {
                                this.paging.pageUp();
                                break;
                            }
                            case N: {
                                this.paging.previousMatch();
                                break;
                            }
                            case n: {
                                this.paging.nextMatch();
                                break;
                            }
                            case SLASH: {
                                this.paging.search();
                                break;
                            }
                            case SEMI_COLON: 
                            case UP_2: 
                            case UP: {
                                this.paging.lineUp();
                                break;
                            }
                            case ENTER: 
                            case CTRL_M: 
                            case DOWN: 
                            case DOWN_2: {
                                this.paging.lineDown();
                                break;
                            }
                            case HOME: 
                            case HOME_2: 
                            case g: {
                                this.paging.goHome();
                                break;
                            }
                            case END: 
                            case END_2: 
                            case END_3: 
                            case G: {
                                this.paging.goEnd();
                                break;
                            }
                            case q: 
                            case Q: 
                            case ESC: {
                                this.paging.exit();
                            }
                        }
                        continue;
                    }
                    catch (InterruptedException ex) {
                        this.getConnection().write(ANSI.CURSOR_RESTORE);
                        this.getConnection().stdoutHandler().accept(ANSI.ERASE_LINE_FROM_CURSOR);
                        this.paging.exit();
                        continue;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                this.paging.printCurrentLine();
            }
        }
        finally {
            this.paging.pagingDone();
            this.paging = null;
            this.outputCollector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key read() throws InterruptedException {
        ActionDecoder decoder = new ActionDecoder();
        Key[] key = new Key[]{null};
        CountDownLatch latch = new CountDownLatch(1);
        Attributes attributes = this.getConnection().enterRawMode();
        Consumer<Signal> prevHandler = this.getConnection().getSignalHandler();
        this.getConnection().setSignalHandler(signal -> {
            switch (signal) {
                case INT: {
                    latch.countDown();
                }
            }
        });
        try {
            this.getConnection().setStdinHandler(keys -> {
                decoder.add((int[])keys);
                if (decoder.hasNext()) {
                    key[0] = Key.findStartKey(decoder.next().buffer().array());
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            finally {
                this.getConnection().setStdinHandler(null);
            }
        }
        finally {
            this.getConnection().setAttributes(attributes);
            this.getConnection().setSignalHandler(prevHandler);
        }
        return key[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPattern() throws InterruptedException, IOException {
        CountDownLatch latch = new CountDownLatch(1);
        String[] out = new String[1];
        Consumer<Signal> prevHandler = this.getConnection().getSignalHandler();
        this.getConnection().setSignalHandler(signal -> {
            prevHandler.accept((Signal)((Object)signal));
            switch (signal) {
                case INT: {
                    latch.countDown();
                }
            }
        });
        this.getReadline().readline(this.getConnection(), new Prompt("/", (Character)null), newLine -> {
            out[0] = newLine;
            latch.countDown();
        }, null, null, this.searchHistory, null, RED_PATTERN_READLINE_FLAGS);
        try {
            latch.await();
        }
        finally {
            this.getConnection().setSignalHandler(prevHandler);
        }
        if (out[0] == null) {
            throw new InterruptedException();
        }
        return out[0];
    }

    static {
        RED_PATTERN_READLINE_FLAGS.put(ReadlineFlag.NO_PROMPT_REDRAW_ON_INTR, Integer.MAX_VALUE);
    }

    private class Paging {
        private boolean notFound;
        private boolean searchingMode;
        private int currentLine;
        private int allLines;
        private int lastScrolledLines;
        private List<String> lines;
        private final String[] splitLines;
        private int jumpIndex = -1;
        private String pattern;
        private int max;
        private boolean paging;
        private final boolean alternateSupported;

        Paging(String output, Size termSize) {
            this.splitLines = output.split("\\R", -1);
            this.lines = this.buildLines(termSize);
            this.lastScrolledLines = this.lines.size();
            this.max = termSize.getHeight() - 1;
            this.alternateSupported = Config.isWindows() ? WinSysTerminal.isVTSupported() : true;
            if (this.lines.size() > this.max) {
                if (this.alternateSupported) {
                    PagingSupport.this.getConnection().write(ANSI.ALTERNATE_BUFFER);
                    PagingSupport.this.clearScreen();
                }
                this.paging = true;
            }
        }

        private List<String> buildLines(Size size) {
            ArrayList<String> lst = new ArrayList<String>();
            int width = Config.isWindows() ? size.getWidth() - 1 : size.getWidth();
            String[] stringArray = this.splitLines;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String l;
                String remaining = l = stringArray[i];
                do {
                    String st = remaining.substring(0, Math.min(remaining.length(), width));
                    lst.add(st);
                } while (!(remaining = remaining.substring(Math.min(remaining.length(), width))).isEmpty());
            }
            return lst;
        }

        int getMax() {
            return this.max;
        }

        void pagingDone() {
            if (this.paging && this.alternateSupported) {
                PagingSupport.this.getConnection().write(ANSI.MAIN_BUFFER);
                this.printScrolledLines();
            }
        }

        boolean needPrompt() {
            return this.currentLine > this.getMax() - 1 && this.jumpIndex == -1 || this.endBuffer() && this.searchingMode;
        }

        boolean inWorkflow() {
            return this.allLines < this.lines.size() || this.searchingMode;
        }

        void exit() {
            this.lastScrolledLines = this.allLines;
            this.allLines = this.lines.size();
            this.searchingMode = false;
        }

        void pageDown() {
            this.notFound = false;
            this.currentLine = 0;
            if (this.endBuffer()) {
                this.exit();
            }
        }

        void pageUp() {
            if (!this.alternateSupported) {
                return;
            }
            PagingSupport.this.clearScreen();
            this.notFound = false;
            this.currentLine = 0;
            this.allLines = this.allLines > 2 * this.getMax() ? (this.allLines -= 2 * this.getMax()) : 0;
        }

        void previousMatch() {
            if (!this.alternateSupported) {
                return;
            }
            if (!this.searchingMode && PagingSupport.this.searchHistory.size() != 0) {
                int[] p = PagingSupport.this.searchHistory.get(PagingSupport.this.searchHistory.size() - 1);
                this.pattern = Parser.fromCodePoints(p);
                this.searchingMode = true;
            }
            if (this.searchingMode) {
                int previous;
                if (this.allLines <= this.getMax()) {
                    this.notFound = true;
                }
                if ((previous = this.previousMatch(this.pattern, this.lines, this.allLines - this.getMax() - 1)) >= 0) {
                    this.jumpIndex = this.allLines - previous - 1;
                    this.notFound = false;
                    this.resetScreen();
                } else {
                    this.notFound = true;
                }
            }
        }

        private int previousMatch(String pattern, List<String> lines, int currentLine) {
            int previous = 0;
            for (int i = currentLine; i >= 0; --i) {
                String l = lines.get(i);
                if (l.contains(pattern)) {
                    return previous;
                }
                ++previous;
            }
            return -1;
        }

        private void nextMatch() {
            if (!this.alternateSupported) {
                return;
            }
            if (this.searchingMode) {
                if (this.endBuffer()) {
                    this.notFound = true;
                } else {
                    int start = this.allLines - this.getMax() < 0 ? 0 : this.allLines - this.getMax();
                    int next = this.nextMatch(this.pattern, this.lines, start + 1);
                    if (next >= 0) {
                        this.jumpIndex = Math.min(this.allLines + next + 1, this.lines.size());
                        this.notFound = false;
                        this.resetScreen();
                    } else {
                        this.notFound = true;
                    }
                }
            } else if (PagingSupport.this.searchHistory.size() != 0) {
                int[] p = PagingSupport.this.searchHistory.get(PagingSupport.this.searchHistory.size() - 1);
                this.doSearch(Parser.fromCodePoints(p));
            }
        }

        private int nextMatch(String pattern, List<String> lines, int currentLine) {
            int next = 0;
            for (int i = currentLine; i < lines.size(); ++i) {
                String l = lines.get(i);
                if (l.contains(pattern)) {
                    return next;
                }
                ++next;
            }
            return -1;
        }

        private void search() throws InterruptedException, IOException {
            if (!this.alternateSupported) {
                return;
            }
            this.doSearch(PagingSupport.this.readPattern());
        }

        private void doSearch(String pattern) {
            if (pattern == null || pattern.isEmpty()) {
                this.jumpIndex = this.allLines;
            } else {
                this.pattern = pattern;
                int start = this.allLines - this.getMax() < 0 ? 0 : this.allLines - this.getMax();
                int next = this.nextMatch(pattern, this.lines, start);
                if (next >= 0) {
                    this.jumpIndex = Math.min(this.allLines + next, this.lines.size());
                    this.searchingMode = true;
                    this.notFound = false;
                } else {
                    this.notFound = true;
                    int n = this.nextMatch(pattern, this.lines, 0);
                    if (n >= 0) {
                        this.searchingMode = true;
                    }
                    this.jumpIndex = this.allLines;
                }
            }
            this.resetScreen();
        }

        private void lineUp() {
            if (!this.alternateSupported) {
                return;
            }
            this.notFound = false;
            if (this.allLines > this.getMax()) {
                this.currentLine = 0;
                this.allLines -= this.getMax() + 1;
                PagingSupport.this.clearScreen();
            }
        }

        private void lineDown() {
            this.notFound = false;
            if (this.endBuffer()) {
                this.exit();
            }
            --this.currentLine;
        }

        private int getPercentage() {
            return this.allLines * 100 / this.lines.size();
        }

        private String nextCurrentLine() {
            String line = this.lines.get(this.allLines);
            ++this.currentLine;
            ++this.allLines;
            if (this.jumpIndex == this.allLines) {
                this.currentLine = this.getMax();
                this.jumpIndex = -1;
            }
            return line;
        }

        private boolean endBuffer() {
            return this.allLines == this.lines.size();
        }

        private void redraw(Size size) {
            if (!this.alternateSupported) {
                return;
            }
            int oldMax = this.max;
            this.max = size.getHeight() - 1;
            this.lines = this.buildLines(size);
            this.jumpIndex = this.lines.size() > this.max ? this.allLines + (this.max - oldMax) : -1;
            this.lastScrolledLines = this.lines.size();
            this.resetScreen();
            while (this.inWorkflow() && !this.needPrompt()) {
                this.printCurrentLine();
            }
            this.drawPrompt();
        }

        private void printCurrentLine() {
            String l = this.nextCurrentLine();
            if (this.searchingMode) {
                PagingSupport.this.displayHightlighted(this.pattern, l);
            } else {
                PagingSupport.this.getConnection().write(l + Config.getLineSeparator());
            }
        }

        private void printScrolledLines() {
            for (int i = 0; i < this.lastScrolledLines; ++i) {
                String l = this.lines.get(i);
                PagingSupport.this.getConnection().write(l + Config.getLineSeparator());
            }
        }

        private void drawPrompt() {
            if (this.notFound) {
                PagingSupport.this.getConnection().write(ANSI.INVERT_BACKGROUND);
                PagingSupport.this.getConnection().write("Pattern not found");
                PagingSupport.this.getConnection().write("\u001b[0m");
            } else {
                PagingSupport.this.getConnection().write("--More(" + this.getPercentage() + "%)--");
            }
        }

        private void goHome() {
            if (!this.alternateSupported) {
                return;
            }
            this.notFound = false;
            this.resetScreen();
        }

        private void goEnd() {
            this.notFound = false;
            if (this.allLines < this.lines.size() - 1) {
                this.jumpIndex = this.lines.size() - 1;
            }
        }

        private void resetScreen() {
            this.currentLine = 0;
            this.allLines = 0;
            PagingSupport.this.clearScreen();
        }
    }
}

