/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.DefaultArtifactCoordinate;

public final class TransferUtils {
    private TransferUtils() {
    }

    public static ArtifactCoordinate toArtifactCoordinate(Artifact artifact) {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(artifact.getGroupId());
        coordinate.setArtifactId(artifact.getArtifactId());
        coordinate.setVersion(artifact.getVersion());
        coordinate.setExtension(artifact.getArtifactHandler().getExtension());
        coordinate.setClassifier(artifact.getClassifier());
        return coordinate;
    }

    public static ArtifactCoordinate toArtifactCoordinate(Extension extension) {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(extension.getGroupId());
        coordinate.setArtifactId(extension.getArtifactId());
        coordinate.setVersion(extension.getVersion());
        return coordinate;
    }

    public static ArtifactCoordinate toArtifactCoordinate(Parent parent) {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(parent.getGroupId());
        coordinate.setArtifactId(parent.getArtifactId());
        coordinate.setVersion(parent.getVersion());
        coordinate.setExtension("pom");
        return coordinate;
    }

    public static ArtifactCoordinate toArtifactCoordinate(Plugin plugin) {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(plugin.getGroupId());
        coordinate.setArtifactId(plugin.getArtifactId());
        coordinate.setVersion(plugin.getVersion());
        return coordinate;
    }

    public static ArtifactCoordinate toArtifactCoordinate(ReportPlugin plugin) {
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(plugin.getGroupId());
        coordinate.setArtifactId(plugin.getArtifactId());
        coordinate.setVersion(plugin.getVersion());
        return coordinate;
    }
}

