/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import ghidra.framework.main.ZoomedImagePainter;
import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import java.awt.Rectangle;
import javax.swing.Icon;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

class ZoomImageRunner {
    private static final float DEFAULT_MAGNIFY_FACTOR = 25.0f;
    private GGlassPane dockingGlassPane;
    private Animator animator;
    private TimingTarget finishedCallbackTarget;

    public ZoomImageRunner(GGlassPane glassPane, final ZoomedImagePainter painter, Icon icon) {
        this.dockingGlassPane = glassPane;
        glassPane.addPainter((GGlassPanePainter)painter);
        this.animator = this.createSpringAnimator(glassPane.getBounds(), icon.getIconWidth(), painter);
        this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void end() {
                ZoomImageRunner.this.dockingGlassPane.removePainter((GGlassPanePainter)painter);
                ZoomImageRunner.this.dockingGlassPane.repaint();
                if (ZoomImageRunner.this.finishedCallbackTarget != null) {
                    ZoomImageRunner.this.finishedCallbackTarget.end();
                }
            }

            public void timingEvent(float fraction) {
                ZoomImageRunner.this.dockingGlassPane.repaint();
            }
        });
    }

    public void addTimingTargetListener(TimingTarget newFinishedTarget) {
        this.finishedCallbackTarget = newFinishedTarget;
    }

    public void run() {
        this.animator.start();
    }

    private Animator createSpringAnimator(Rectangle iconContainerBounds, int imageWidth, ZoomedImagePainter iconPainter) {
        float magnifyFactor = this.recalculateMagnifyFactor(iconContainerBounds, imageWidth);
        iconPainter.setMagnifyFactor(magnifyFactor);
        Animator newAnimator = PropertySetter.createAnimator((int)850, (Object)iconPainter, (String)"zoom", (Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f)});
        newAnimator.setAcceleration(0.2f);
        newAnimator.setDeceleration(0.2f);
        return newAnimator;
    }

    private float recalculateMagnifyFactor(Rectangle containerBounds, int imageWidth) {
        double width = containerBounds.getWidth();
        return Math.min(25.0f, (float)(width / (double)imageWidth) * 1.25f);
    }
}

