/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatable.DomainFileProvider;
import ghidra.framework.main.projectdata.actions.CheckoutsDialog;
import ghidra.framework.main.projectdata.actions.VersionControlAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.remote.User;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import java.util.List;

public class VersionControlViewCheckOutAction
extends VersionControlAction {
    public VersionControlViewCheckOutAction(Plugin plugin) {
        super("View Check Outs", plugin.getName(), plugin.getTool());
        this.setPopupMenuData(new MenuData(new String[]{"View Check Outs..."}, null, "Repository"));
        this.setDescription("View current check outs");
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(DomainFileProvider context) {
        this.viewCheckouts(context.getSelectedFiles());
    }

    @Override
    public boolean isEnabledForContext(DomainFileProvider context) {
        List<DomainFile> domainFiles = context.getSelectedFiles();
        if (domainFiles.size() != 1) {
            return false;
        }
        DomainFile domainFile = domainFiles.get(0);
        return domainFile.isVersioned();
    }

    private void viewCheckouts(List<DomainFile> domainFiles) {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        if (domainFiles.size() != 1) {
            return;
        }
        try {
            DomainFile domainFile = domainFiles.get(0);
            User user = this.repository != null ? this.repository.getUser() : null;
            ItemCheckoutStatus[] checkouts = domainFile.getCheckouts();
            if (checkouts.length == 0) {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.tool.getToolFrame(), (String)"No Checkouts Exist", (Object)("No checkouts exist for " + domainFile.getName()));
            } else {
                CheckoutsDialog dialog = new CheckoutsDialog(this.tool, user, domainFile, checkouts);
                this.tool.showDialog(dialog);
            }
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)this.repository, (Exception)e, (String)"Fetch Check Out Status", (Component)this.tool.getToolFrame());
        }
    }
}

