/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import ghidra.framework.Application;
import java.io.File;

public class ExtensionDetails
implements Comparable<ExtensionDetails> {
    private String installPath;
    private String archivePath;
    private String name;
    private String description;
    private String createdOn;
    private String author;
    private String version;

    public ExtensionDetails(String name, String description, String author, String createdOn, String version) {
        this.name = name;
        this.description = description;
        this.author = author;
        this.createdOn = createdOn;
        this.version = version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionDetails other = (ExtensionDetails)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public void setInstallPath(String path) {
        this.installPath = path;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public void setArchivePath(String path) {
        this.archivePath = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String date) {
        this.createdOn = date;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isInstalled() {
        if (this.installPath == null || this.installPath.isEmpty()) {
            return false;
        }
        if (Application.inSingleJarMode()) {
            return true;
        }
        File mm = new File(this.installPath, "Module.manifest");
        return mm.exists();
    }

    @Override
    public int compareTo(ExtensionDetails other) {
        return this.name.compareTo(other.name);
    }
}

