/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;

public class BTNodeDescriptor {
    public static final int BT_LEAF_NODE = -1;
    public static final int BT_INDEX_NODE = 0;
    public static final int BT_HEADER_NODE = 1;
    public static final int BT_MAP_NODE = 2;
    private static final int STRUCTSIZE = 14;
    private final byte[] fLink = new byte[4];
    private final byte[] bLink = new byte[4];
    private final byte[] kind = new byte[1];
    private final byte[] height = new byte[1];
    private final byte[] numRecords = new byte[2];
    private final byte[] reserved = new byte[2];

    public BTNodeDescriptor(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.fLink, 0, 4);
        System.arraycopy(data, offset + 4, this.bLink, 0, 4);
        System.arraycopy(data, offset + 8, this.kind, 0, 1);
        System.arraycopy(data, offset + 9, this.height, 0, 1);
        System.arraycopy(data, offset + 10, this.numRecords, 0, 2);
        System.arraycopy(data, offset + 12, this.reserved, 0, 2);
    }

    public static int length() {
        return 14;
    }

    public int getFLink() {
        return Util.readIntBE((byte[])this.fLink);
    }

    public int getBLink() {
        return Util.readIntBE((byte[])this.bLink);
    }

    public byte getKind() {
        return Util.readByteBE((byte[])this.kind);
    }

    public byte getHeight() {
        return Util.readByteBE((byte[])this.height);
    }

    public short getNumRecords() {
        return Util.readShortBE((byte[])this.numRecords);
    }

    public short getReserved() {
        return Util.readShortBE((byte[])this.reserved);
    }

    public String getKindAsString() {
        byte kind = this.getKind();
        String result = kind == -1 ? "kBTLeafNode" : (kind == 0 ? "kBTIndexNode" : (kind == 1 ? "kBTHeaderNode" : (kind == 2 ? "kBTMapNode" : "UNKNOWN!")));
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " fLink: " + this.getFLink() + "");
        ps.println(prefix + " bLink: " + this.getBLink() + "");
        ps.println(prefix + " kind: " + this.getKind() + " (" + this.getKindAsString() + ")");
        ps.println(prefix + " height: " + this.getHeight() + "");
        ps.println(prefix + " numRecords: " + this.getNumRecords() + "");
        ps.println(prefix + " reserved: 0x" + Util.toHexStringBE((short)this.getReserved()) + "");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "BTNodeDescriptor:");
        this.printFields(ps, prefix);
    }
}

