/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import java.util.Date;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.finder.ExtendedFolderInfo;
import org.catacombae.hfsexplorer.types.finder.FolderInfo;
import org.catacombae.hfsexplorer.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusBSDInfo;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogAttributes;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogLeafRecordData;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusDate;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusDateField;

public class HFSPlusCatalogFolder
extends HFSPlusCatalogLeafRecordData
implements HFSPlusCatalogAttributes,
StructElements {
    private final byte[] recordType = new byte[2];
    private final byte[] flags = new byte[2];
    private final byte[] valence = new byte[4];
    private final HFSCatalogNodeID folderID;
    private final byte[] createDate = new byte[4];
    private final byte[] contentModDate = new byte[4];
    private final byte[] attributeModDate = new byte[4];
    private final byte[] accessDate = new byte[4];
    private final byte[] backupDate = new byte[4];
    private final HFSPlusBSDInfo permissions;
    private final FolderInfo userInfo;
    private final ExtendedFolderInfo finderInfo;
    private final byte[] textEncoding = new byte[4];
    private final byte[] reserved = new byte[4];

    public HFSPlusCatalogFolder(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.recordType, 0, 2);
        System.arraycopy(data, offset + 2, this.flags, 0, 2);
        System.arraycopy(data, offset + 4, this.valence, 0, 4);
        this.folderID = new HFSCatalogNodeID(data, offset + 8);
        System.arraycopy(data, offset + 12, this.createDate, 0, 4);
        System.arraycopy(data, offset + 16, this.contentModDate, 0, 4);
        System.arraycopy(data, offset + 20, this.attributeModDate, 0, 4);
        System.arraycopy(data, offset + 24, this.accessDate, 0, 4);
        System.arraycopy(data, offset + 28, this.backupDate, 0, 4);
        this.permissions = new HFSPlusBSDInfo(data, offset + 32);
        this.userInfo = new FolderInfo(data, offset + 48);
        this.finderInfo = new ExtendedFolderInfo(data, offset + 64);
        System.arraycopy(data, offset + 80, this.textEncoding, 0, 4);
        System.arraycopy(data, offset + 84, this.reserved, 0, 4);
    }

    public static int length() {
        return 88;
    }

    public short getRecordType() {
        return Util.readShortBE((byte[])this.recordType);
    }

    public short getFlags() {
        return Util.readShortBE((byte[])this.flags);
    }

    public int getValence() {
        return Util.readIntBE((byte[])this.valence);
    }

    public HFSCatalogNodeID getFolderID() {
        return this.folderID;
    }

    public int getCreateDate() {
        return Util.readIntBE((byte[])this.createDate);
    }

    public int getContentModDate() {
        return Util.readIntBE((byte[])this.contentModDate);
    }

    public int getAttributeModDate() {
        return Util.readIntBE((byte[])this.attributeModDate);
    }

    public int getAccessDate() {
        return Util.readIntBE((byte[])this.accessDate);
    }

    public int getBackupDate() {
        return Util.readIntBE((byte[])this.backupDate);
    }

    public HFSPlusBSDInfo getPermissions() {
        return this.permissions;
    }

    public FolderInfo getUserInfo() {
        return this.userInfo;
    }

    public ExtendedFolderInfo getFinderInfo() {
        return this.finderInfo;
    }

    public int getTextEncoding() {
        return Util.readIntBE((byte[])this.textEncoding);
    }

    public int getReserved() {
        return Util.readIntBE((byte[])this.reserved);
    }

    public Date getCreateDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getCreateDate());
    }

    public Date getContentModDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getContentModDate());
    }

    public Date getAttributeModDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getAttributeModDate());
    }

    public Date getAccessDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getAccessDate());
    }

    public Date getBackupDateAsDate() {
        return HFSPlusDate.gmtTimestampToDate(this.getBackupDate());
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " recordType: " + this.getRecordType());
        ps.println(prefix + " flags: " + this.getFlags());
        ps.println(prefix + " valence: " + this.getValence());
        ps.println(prefix + " folderID: ");
        this.getFolderID().print(ps, prefix + "  ");
        ps.println(prefix + " createDate: " + this.getCreateDateAsDate());
        ps.println(prefix + " contentModDate: " + this.getContentModDateAsDate());
        ps.println(prefix + " attributeModDate: " + this.getAttributeModDateAsDate());
        ps.println(prefix + " accessDate: " + this.getAccessDateAsDate());
        ps.println(prefix + " backupDate: " + this.getBackupDateAsDate());
        ps.println(prefix + " permissions: ");
        this.getPermissions().print(ps, prefix + "  ");
        ps.println(prefix + " userInfo: ");
        this.getUserInfo().print(ps, prefix + "  ");
        ps.println(prefix + " finderInfo: ");
        this.getFinderInfo().print(ps, prefix + "  ");
        ps.println(prefix + " textEncoding: " + this.getTextEncoding());
        ps.println(prefix + " reserved: " + this.getReserved());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusCatalogFolder:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[HFSPlusCatalogFolder.length()];
        int offset = 0;
        System.arraycopy(this.recordType, 0, result, offset, this.recordType.length);
        System.arraycopy(this.flags, 0, result, offset += this.recordType.length, this.flags.length);
        System.arraycopy(this.valence, 0, result, offset += this.flags.length, this.valence.length);
        byte[] tempData = this.folderID.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.valence.length, tempData.length);
        System.arraycopy(this.createDate, 0, result, offset += tempData.length, this.createDate.length);
        System.arraycopy(this.contentModDate, 0, result, offset += this.createDate.length, this.contentModDate.length);
        System.arraycopy(this.attributeModDate, 0, result, offset += this.contentModDate.length, this.attributeModDate.length);
        System.arraycopy(this.accessDate, 0, result, offset += this.attributeModDate.length, this.accessDate.length);
        System.arraycopy(this.backupDate, 0, result, offset += this.accessDate.length, this.backupDate.length);
        tempData = this.permissions.getBytes();
        System.arraycopy(tempData, 0, result, offset += this.backupDate.length, tempData.length);
        offset += tempData.length;
        tempData = this.userInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        offset += tempData.length;
        tempData = this.finderInfo.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length);
        System.arraycopy(this.textEncoding, 0, result, offset += tempData.length, this.textEncoding.length);
        System.arraycopy(this.reserved, 0, result, offset += this.textEncoding.length, this.reserved.length);
        offset += this.reserved.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusCatalogFolder.class.getSimpleName());
        db.addUIntBE("recordType", this.recordType);
        db.addUIntBE("flags", this.flags);
        db.addUIntBE("valence", this.valence);
        db.add("folderID", this.folderID.getStructElements());
        db.add("createDate", new HFSPlusDateField(this.createDate, false));
        db.add("contentModDate", new HFSPlusDateField(this.contentModDate, false));
        db.add("attributeModDate", new HFSPlusDateField(this.attributeModDate, false));
        db.add("accessDate", new HFSPlusDateField(this.accessDate, false));
        db.add("backupDate", new HFSPlusDateField(this.backupDate, false));
        db.add("permissions", this.permissions.getStructElements());
        db.add("userInfo", this.userInfo.getStructElements());
        db.add("finderInfo", this.finderInfo.getStructElements());
        db.addUIntBE("textEncoding", this.textEncoding);
        db.addUIntBE("reserved", this.reserved);
        return db.getResult();
    }
}

