/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.filechooser.GhidraFileChooser;
import generic.jar.ResourceFile;
import ghidra.app.analyzers.FunctionStartAnalyzer;
import ghidra.bitpatterns.gui.ClipboardPanel;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.gui.PatternInfoRowObject;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.PatternType;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.bytesearch.AlignRule;
import ghidra.util.bytesearch.DittedBitSequence;
import ghidra.util.bytesearch.MatchAction;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.bytesearch.PatternPairSet;
import ghidra.util.bytesearch.PostRule;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import org.xml.sax.SAXException;

public class ImportPatternFileActionListener
implements ActionListener {
    private static final String XML_IMPORT_DIR_PROPERTY = "ImportPatternFileActionListener_XML_IMPORT_DIR_PROPERTY";
    private Component component;
    private FunctionBitPatternsExplorerPlugin plugin;

    public ImportPatternFileActionListener(FunctionBitPatternsExplorerPlugin plugin, Component component) {
        this.component = component;
        this.plugin = plugin;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GhidraFileChooser fileChooser = new GhidraFileChooser(this.component);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setTitle("Select Pattern File");
        String baseDir = Preferences.getProperty((String)XML_IMPORT_DIR_PROPERTY);
        if (baseDir != null) {
            fileChooser.setCurrentDirectory(new File(baseDir));
        }
        ExtensionFileFilter xmlFilter = new ExtensionFileFilter("xml", "XML Files");
        fileChooser.setFileFilter((GhidraFileFilter)xmlFilter);
        File patternFile = fileChooser.getSelectedFile();
        if (fileChooser.wasCancelled() || patternFile == null) {
            return;
        }
        Preferences.setProperty((String)XML_IMPORT_DIR_PROPERTY, (String)fileChooser.getCurrentDirectory().getAbsolutePath());
        Preferences.store();
        ResourceFile resource = new ResourceFile(patternFile);
        try {
            PatternPairSet pairSet = ClipboardPanel.parsePatternPairSet(resource);
            if (pairSet == null) {
                return;
            }
            this.plugin.clearPatterns();
            for (DittedBitSequence pre : pairSet.getPreSequences()) {
                PatternInfoRowObject preRow = new PatternInfoRowObject(PatternType.PRE, pre, null);
                this.plugin.addPattern(preRow);
            }
            this.processPostPatterns(pairSet);
        }
        catch (IOException | SAXException e1) {
            Msg.showError((Object)this, (Component)this.component, (String)"Import Error", (Object)("Error Importing file " + patternFile.getAbsolutePath()), (Throwable)e1);
        }
        this.plugin.updateClipboard();
    }

    private void processPostPatterns(PatternPairSet pairSet) {
        for (Pattern post : pairSet.getPostPatterns()) {
            int alignment = 0;
            for (PostRule postRule : post.getPostRules()) {
                if (!(postRule instanceof AlignRule)) continue;
                AlignRule align = (AlignRule)postRule;
                alignment = align.getAlignMask();
                break;
            }
            ContextRegisterFilter cRegFilter = new ContextRegisterFilter();
            for (MatchAction matchAction : post.getMatchActions()) {
                if (!(matchAction instanceof FunctionStartAnalyzer.ContextAction)) continue;
                FunctionStartAnalyzer.ContextAction contextAction = (FunctionStartAnalyzer.ContextAction)matchAction;
                String cReg = contextAction.getName();
                BigInteger value = contextAction.getValue();
                cRegFilter.addRegAndValueToFilter(cReg, value);
            }
            PatternInfoRowObject postRow = new PatternInfoRowObject(PatternType.FIRST, post, cRegFilter.getValueMap().isEmpty() ? null : cRegFilter);
            if (alignment != 0) {
                postRow.setAlignment(alignment + 1);
            }
            this.plugin.addPattern(postRow);
        }
    }
}

