/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.cmd.register.SetRegisterCmd;
import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.LockException;
import ghidra.javaclass.format.ClassFileJava;
import ghidra.javaclass.format.JavaClassUtil;
import ghidra.javaclass.format.MethodInfoJava;
import ghidra.javaclass.format.attributes.CodeAttribute;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JavaLoader
extends AbstractLibrarySupportLoader {
    private static final String JAVA_NAME = "Java Class File";
    private Register alignmentReg;
    public static final long CODE_OFFSET = 65536L;
    public static final String CONSTANT_POOL = "constantPool";

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        boolean validClass = false;
        if (this.checkClass(provider)) {
            validClass = true;
        }
        if (validClass) {
            loadSpecs.add(new LoadSpec((Loader)this, 0L, new LanguageCompilerSpecPair("JVM:BE:32:default", "default"), true));
        }
        return loadSpecs;
    }

    private boolean checkClass(ByteProvider provider) throws IOException {
        BinaryReader reader = new BinaryReader(provider, false);
        int magic = reader.peekNextInt();
        if (magic != -889275714) {
            return false;
        }
        try {
            new ClassFileJava(reader);
        }
        catch (IOException e) {
            return false;
        }
        catch (RuntimeException re) {
            return false;
        }
        return true;
    }

    public String getName() {
        return JAVA_NAME;
    }

    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
        try {
            this.doLoad(provider, program, monitor);
        }
        catch (LockException e) {
            e.printStackTrace();
        }
        catch (MemoryConflictException e) {
            e.printStackTrace();
        }
        catch (AddressOverflowException e) {
            e.printStackTrace();
        }
        catch (CancelledException e) {
            e.printStackTrace();
        }
        catch (DuplicateNameException e) {
            e.printStackTrace();
        }
    }

    public void load(ByteProvider provider, Program program, TaskMonitor monitor) throws IOException {
        this.load(provider, null, null, program, monitor, null);
    }

    private void doLoad(ByteProvider provider, Program program, TaskMonitor monitor) throws LockException, MemoryConflictException, AddressOverflowException, CancelledException, DuplicateNameException, IOException {
        AddressFactory af = program.getAddressFactory();
        AddressSpace space = af.getAddressSpace(CONSTANT_POOL);
        Memory memory = program.getMemory();
        this.alignmentReg = program.getRegister("alignmentPad");
        BinaryReader reader = new BinaryReader(provider, false);
        ClassFileJava classFile = new ClassFileJava(reader);
        Address address = space.getAddress(0L);
        memory.createInitializedBlock("_" + provider.getName() + "_", address, provider.getInputStream(0L), provider.length(), monitor, false);
        this.createMethodLookupMemoryBlock(program, monitor);
        this.createMethodMemoryBlocks(program, provider, classFile, monitor);
    }

    private void createMethodLookupMemoryBlock(Program program, TaskMonitor monitor) {
        Address address = this.toAddr(program, 0xE0000000L);
        MemoryBlock block = null;
        Memory memory = program.getMemory();
        try {
            block = memory.createInitializedBlock("method_lookup", address, 262144L, (byte)-1, monitor, false);
        }
        catch (LockException | AddressOverflowException | MemoryConflictException | CancelledException | DuplicateNameException e) {
            e.printStackTrace();
        }
        block.setRead(true);
        block.setWrite(false);
        block.setExecute(false);
    }

    private void createMethodMemoryBlocks(Program program, ByteProvider provider, ClassFileJava classFile, TaskMonitor monitor) {
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        MethodInfoJava[] methods = classFile.getMethods();
        monitor.setMessage("Processing Methods...");
        monitor.setProgress(0L);
        monitor.setMaximum((long)methods.length);
        Address start = this.toAddr(program, 65536L);
        try {
            int max = methods.length;
            for (int i = 0; i < max; ++i) {
                MethodInfoJava method = methods[i];
                monitor.incrementProgress(1L);
                CodeAttribute code = method.getCodeAttribute();
                if (code == null) continue;
                int length = code.getCodeLength();
                long offset = code.getCodeOffset();
                Memory memory = program.getMemory();
                int nameIndex = method.getNameIndex();
                int descriptorIndex = method.getDescriptorIndex();
                ConstantPoolUtf8Info methodNameInfo = (ConstantPoolUtf8Info)constantPool[nameIndex];
                ConstantPoolUtf8Info methodDescriptorInfo = (ConstantPoolUtf8Info)constantPool[descriptorIndex];
                String methodName = methodNameInfo.getString() + methodDescriptorInfo.getString();
                MemoryBlock memoryBlock = memory.createInitializedBlock(methodName, start, provider.getInputStream(offset), (long)length, monitor, false);
                Address methodIndexAddress = JavaClassUtil.toLookupAddress(program, i);
                program.getMemory().setInt(methodIndexAddress, (int)start.getOffset());
                program.getListing().createData(methodIndexAddress, (DataType)PointerDataType.dataType);
                this.setAlignmentInfo(program, new AddressSet(memoryBlock.getStart(), memoryBlock.getEnd()));
                start = start.add((long)(length + 1));
                while (start.getOffset() % 4L != 0L) {
                    start = start.add(1L);
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void setAlignmentInfo(Program program, AddressSet set) {
        AddressIterator addressIterator = set.getAddresses(true);
        int alignmentValue = 3;
        while (addressIterator.hasNext()) {
            Address address = addressIterator.next();
            SetRegisterCmd cmd = new SetRegisterCmd(this.alignmentReg, address, address, BigInteger.valueOf(alignmentValue));
            cmd.applyTo((DomainObject)program);
            if (alignmentValue == 0) {
                alignmentValue = 3;
                continue;
            }
            --alignmentValue;
        }
    }

    private Address toAddr(Program program, long offset) {
        return program.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
    }
}

