/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.Collection;

public interface Hypergraph<V, E> {
    public Collection<E> getEdges();

    public Collection<V> getVertices();

    public boolean containsVertex(V var1);

    public boolean containsEdge(E var1);

    public int getEdgeCount();

    public int getVertexCount();

    public Collection<V> getNeighbors(V var1);

    public Collection<E> getIncidentEdges(V var1);

    public Collection<V> getIncidentVertices(E var1);

    public E findEdge(V var1, V var2);

    public Collection<E> findEdgeSet(V var1, V var2);

    public boolean addVertex(V var1);

    public boolean addEdge(E var1, Collection<? extends V> var2);

    public boolean addEdge(E var1, Collection<? extends V> var2, EdgeType var3);

    public boolean removeVertex(V var1);

    public boolean removeEdge(E var1);

    public boolean isNeighbor(V var1, V var2);

    public boolean isIncident(V var1, E var2);

    public int degree(V var1);

    public int getNeighborCount(V var1);

    public int getIncidentCount(E var1);

    public EdgeType getEdgeType(E var1);

    public EdgeType getDefaultEdgeType();

    public Collection<E> getEdges(EdgeType var1);

    public int getEdgeCount(EdgeType var1);

    public Collection<E> getInEdges(V var1);

    public Collection<E> getOutEdges(V var1);

    public int inDegree(V var1);

    public int outDegree(V var1);

    public V getSource(E var1);

    public V getDest(E var1);

    public Collection<V> getPredecessors(V var1);

    public Collection<V> getSuccessors(V var1);
}

