/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import ghidra.util.Msg;
import ghidra.util.ObjectStorage;
import ghidra.util.PrivateSaveable;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SaveableXML
extends PrivateSaveable {
    private final Class<?>[] fields = new Class[]{String.class};
    private Element element;

    public SaveableXML(Element element) {
        this.element = element;
    }

    public SaveableXML() {
    }

    public Class<?>[] getObjectStorageFields() {
        return this.fields;
    }

    public void save(ObjectStorage objStorage) {
        Document document = new Document(this.element);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GenericXMLOutputter xmlOutputter = new GenericXMLOutputter();
        try {
            xmlOutputter.output(document, (OutputStream)outputStream);
        }
        catch (IOException ioe) {
            Msg.error(((Object)((Object)this)).getClass(), (Object)"Unable to save XML data.", (Throwable)ioe);
            return;
        }
        String xmlString = outputStream.toString();
        objStorage.putString(xmlString);
    }

    public void restore(ObjectStorage objStorage) {
        String xmlString = objStorage.getString();
        StringReader reader = new StringReader(xmlString);
        SAXBuilder builder = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        try {
            this.element = builder.build((Reader)reader).getRootElement();
        }
        catch (JDOMException e) {
            Msg.error(((Object)((Object)this)).getClass(), (Object)"Unable to read XML data.", (Throwable)e);
        }
        catch (IOException e) {
            Msg.error(((Object)((Object)this)).getClass(), (Object)"Unable to read XML data.", (Throwable)e);
        }
    }

    public Element getElement() {
        return this.element;
    }

    public int getSchemaVersion() {
        return 0;
    }

    public boolean isUpgradeable(int oldSchemaVersion) {
        return false;
    }

    public boolean upgrade(ObjectStorage oldObjStorage, int oldSchemaVersion, ObjectStorage currentObjStorage) {
        return false;
    }
}

