/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import generic.random.SecureRandomFactory;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.net.ApplicationTrustManagerFactory;
import ghidra.net.SignedToken;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.SyncFailedException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.x500.X500Principal;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class ApplicationKeyManagerUtils {
    public static final String DEFAULT_SIGNING_ALGORITHM = "SHA1withRSA";
    public static final String DEFAULT_AUTH_TYPE = "RSA";
    private static final int MILLISECONDS_PER_DAY = 86400000;

    private ApplicationKeyManagerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignedToken getSignedToken(Principal[] authorities, byte[] token) throws NoSuchAlgorithmException, SignatureException, CertificateException {
        Destroyable privateKey = null;
        X509Certificate[] certificateChain = null;
        try {
            ApplicationKeyManagerFactory keyManagerFactory = ApplicationKeyManagerFactory.getInstance();
            for (KeyManager keyManager : keyManagerFactory.getKeyManagers()) {
                if (!(keyManager instanceof X509KeyManager)) continue;
                X509KeyManager x509KeyManager = (X509KeyManager)keyManager;
                String alias = x509KeyManager.chooseClientAlias(new String[]{DEFAULT_AUTH_TYPE}, authorities, null);
                if (alias == null) continue;
                privateKey = x509KeyManager.getPrivateKey(alias);
                certificateChain = x509KeyManager.getCertificateChain(alias);
                break;
            }
            if (privateKey == null || certificateChain == null) {
                CertificateException e = new CertificateException("suitable PKI certificate not found");
                e.printStackTrace();
                throw e;
            }
            String algorithm = certificateChain[0].getSigAlgName();
            Signature sig = Signature.getInstance(algorithm);
            try {
                sig.initSign((PrivateKey)privateKey);
            }
            catch (InvalidKeyException e) {
                throw new CertificateException("suitable PKI certificate not found", e);
            }
            sig.update(token);
            SignedToken signedToken = new SignedToken(token, sig.sign(), certificateChain, algorithm);
            return signedToken;
        }
        finally {
            if (privateKey != null) {
                try {
                    privateKey.destroy();
                }
                catch (DestroyFailedException destroyFailedException) {}
            }
        }
    }

    public static boolean isMySignature(Principal[] authorities, byte[] token, byte[] signature) throws NoSuchAlgorithmException, SignatureException, CertificateException {
        SignedToken signedToken = ApplicationKeyManagerUtils.getSignedToken(authorities, token);
        return Arrays.equals(signature, signedToken.signature);
    }

    public static X500Principal[] getTrustedIssuers() throws CertificateException {
        TrustManager[] trustManagers = ApplicationTrustManagerFactory.getTrustManagers();
        if (ApplicationTrustManagerFactory.hasCertError()) {
            throw new CertificateException("failed to load CA certs", ApplicationTrustManagerFactory.getCertError());
        }
        HashSet<X500Principal> set = new HashSet<X500Principal>();
        boolean openTrust = true;
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) {
                Msg.warn(ApplicationKeyManagerUtils.class, (Object)("Unexpected trust manager implementation: " + trustManager.getClass().getName()));
                openTrust = false;
                continue;
            }
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            X509Certificate[] acceptedIssuers = x509TrustManager.getAcceptedIssuers();
            if (acceptedIssuers == null) continue;
            openTrust = false;
            for (X509Certificate trustedCert : acceptedIssuers) {
                set.add(trustedCert.getSubjectX500Principal());
            }
        }
        if (openTrust) {
            return null;
        }
        X500Principal[] principals = new X500Principal[set.size()];
        return set.toArray(principals);
    }

    public static void validateClient(X509Certificate[] certChain, String authType) throws CertificateException {
        CertificateException checkFailure = null;
        TrustManager[] trustManagers = ApplicationTrustManagerFactory.getTrustManagers();
        if (ApplicationTrustManagerFactory.hasCertError()) {
            throw new CertificateException("failed to load CA certs", ApplicationTrustManagerFactory.getCertError());
        }
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            try {
                x509TrustManager.checkClientTrusted(certChain, authType);
                checkFailure = null;
                break;
            }
            catch (CertificateException e) {
                checkFailure = e;
            }
        }
        if (checkFailure != null) {
            throw checkFailure;
        }
    }

    private static Certificate[] getCertificateChain(Certificate ... certs) {
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        for (Certificate cert : certs) {
            if (cert == null) continue;
            list.add(cert);
        }
        Certificate[] chain = new Certificate[list.size()];
        return list.toArray(chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore createKeyStore(File keyFile, String keystoreType, char[] protectedPassphrase, String alias, CertificateExtensions certExtensions, String dn, KeyStore.PrivateKeyEntry caSignerKeyEntry, int durationDays) throws KeyStoreException {
        KeyStore keyStore;
        block7: {
            try {
                keyStore = KeyStore.getInstance(keystoreType);
                keyStore.load(null);
                ApplicationKeyManagerUtils.addNewKeyPair(keyStore, alias, dn, certExtensions, protectedPassphrase, caSignerKeyEntry, durationDays);
                if (keyFile == null) break block7;
                try (FileOutputStream out = new FileOutputStream(keyFile);){
                    keyStore.store(out, protectedPassphrase);
                    out.flush();
                    out.getFD().sync();
                    Msg.debug(ApplicationKeyManagerUtils.class, (Object)(out.getChannel().size() + " bytes written to key/cert file: " + keyFile));
                }
                keyFile.setReadable(true, true);
                keyFile.setWritable(false);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new KeyStoreException("failed to generate/store certificate (" + dn + ")", e);
            }
        }
        return keyStore;
    }

    private static void addNewKeyPair(KeyStore keyStore, String alias, String dn, CertificateExtensions certExtensions, char[] protectedPassphrase, KeyStore.PrivateKeyEntry caSignerKeyEntry, int durationDays) throws GeneralSecurityException, IOException {
        X509Certificate signerCert = null;
        if (caSignerKeyEntry != null) {
            Certificate cert = caSignerKeyEntry.getCertificate();
            if (!(cert instanceof X509Certificate)) {
                throw new IllegalArgumentException("Unsupported caSignerKeyEntry - X509 certificate required");
            }
            signerCert = (X509Certificate)cert;
        }
        KeyPairGenerator generator = KeyPairGenerator.getInstance(DEFAULT_AUTH_TYPE);
        SecureRandom random = SecureRandomFactory.getSecureRandom();
        generator.initialize(2048, random);
        X509CertInfo certInfo = new X509CertInfo();
        certInfo.set("version", new CertificateVersion(2));
        certInfo.set("algorithmID", new CertificateAlgorithmId(AlgorithmId.get(DEFAULT_SIGNING_ALGORITHM)));
        certInfo.set("subject.dname", new X500Name(dn));
        Date now = new Date(System.currentTimeMillis());
        long durationMs = (long)durationDays * 86400000L;
        Date end = new Date(now.getTime() + durationMs);
        certInfo.set("validity", new CertificateValidity(now, end));
        String issuer = signerCert != null ? signerCert.getSubjectDN().getName() : dn;
        certInfo.set("issuer.dname", new X500Name(issuer));
        certInfo.set("serialNumber", new CertificateSerialNumber(random.nextInt() & Integer.MAX_VALUE));
        KeyPair keyPair = generator.generateKeyPair();
        certInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
        if (certExtensions == null) {
            certExtensions = new CertificateExtensions();
            KeyUsageExtension keyUsage = new KeyUsageExtension();
            keyUsage.set("digital_signature", true);
            certExtensions.set(PKIXExtensions.KeyUsage_Id.toString(), keyUsage);
        }
        certInfo.set("extensions", certExtensions);
        X509CertImpl cert = new X509CertImpl(certInfo);
        PrivateKey caSignerKey = caSignerKeyEntry != null ? caSignerKeyEntry.getPrivateKey() : keyPair.getPrivate();
        cert.sign(caSignerKey, DEFAULT_SIGNING_ALGORITHM);
        keyStore.setKeyEntry(alias, keyPair.getPrivate(), protectedPassphrase, ApplicationKeyManagerUtils.getCertificateChain(cert, signerCert));
        Msg.debug(ApplicationKeyManagerUtils.class, (Object)("Certificate Generated (" + alias + "): " + cert.getSubjectDN()));
    }

    public static void exportX509Certificates(KeyStore keystore, File outFile) throws IOException, KeyStoreException, CertificateEncodingException {
        FileOutputStream fout = new FileOutputStream(outFile);
        PrintWriter writer = new PrintWriter(fout);
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            Certificate certificate = keystore.getCertificate(aliases.nextElement());
            if (!(certificate instanceof X509Certificate)) continue;
            writer.println("-----BEGIN CERTIFICATE-----");
            String base64 = Base64.getEncoder().encodeToString(certificate.getEncoded());
            while (base64.length() != 0) {
                int endIndex = Math.min(44, base64.length());
                String line = base64.substring(0, endIndex);
                writer.println(line);
                base64 = base64.substring(endIndex);
            }
            writer.println("-----END CERTIFICATE-----");
            writer.println();
        }
        writer.flush();
        try {
            fout.getFD().sync();
        }
        catch (SyncFailedException syncFailedException) {
            // empty catch block
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportKeystore(KeyStore keystore, File outFile, char[] password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        try (FileOutputStream out = new FileOutputStream(outFile);){
            keystore.store(out, password);
            out.flush();
            out.getFD().sync();
        }
    }
}

