/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;

public class CreateArrayInStructureCmd
implements Command {
    private String msg;
    private Address addr;
    private int numElements;
    private DataType dataType;
    private int[] compPath;

    public CreateArrayInStructureCmd(Address addr, int numElements, DataType dt, int[] compPath) {
        this.addr = addr;
        this.numElements = numElements;
        this.dataType = dt;
        this.compPath = compPath;
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        Listing listing = program.getListing();
        if (this.dataType instanceof FactoryDataType) {
            this.msg = "Array not allowed on a Factory data-type: " + this.dataType.getName();
            return false;
        }
        if (this.dataType instanceof Dynamic && !((Dynamic)this.dataType).canSpecifyLength()) {
            this.msg = "Array not allowed on a non-sizable Dynamic data-type: " + this.dataType.getName();
            return false;
        }
        if (this.numElements <= 0) {
            this.msg = "Number of elements must be positive, not " + this.numElements;
            return false;
        }
        Data data = listing.getDataContaining(this.addr);
        Data compData = data.getComponent(this.compPath);
        int elementLength = this.dataType instanceof Dynamic ? compData.getLength() : this.dataType.getLength();
        if (elementLength <= 0) {
            this.msg = "DataType must have fixed size > 0, not " + elementLength;
            return false;
        }
        int length = this.numElements * elementLength;
        int index = compData.getComponentIndex();
        int offset = compData.getParentOffset();
        DataType parentDataType = compData.getParent().getBaseDataType();
        if (!(parentDataType instanceof Structure)) {
            this.msg = "Data not in a structure";
            return false;
        }
        Structure struct = (Structure)parentDataType;
        if (offset + length > struct.getLength()) {
            this.msg = "Array too big for structure";
            return false;
        }
        try {
            ArrayDataType adt = new ArrayDataType(this.dataType, this.numElements, this.dataType.getLength());
            this.clearStruct(struct, compData.getParentOffset(), length);
            if (struct.isInternallyAligned()) {
                struct.insert(index, (DataType)adt, adt.getLength());
            } else {
                struct.replace(index, (DataType)adt, adt.getLength());
            }
        }
        catch (Exception e) {
            this.msg = e.getMessage();
            return false;
        }
        return true;
    }

    private void clearStruct(Structure struct, int offset, int length) {
        DataTypeComponent[] comps = struct.getDefinedComponents();
        int endOffset = offset + length;
        for (int i = comps.length - 1; i >= 0; --i) {
            if (comps[i].getOffset() < offset || comps[i].getOffset() >= endOffset) continue;
            struct.clearComponent(comps[i].getOrdinal());
        }
    }

    public String getStatusMsg() {
        return this.msg;
    }

    public String getName() {
        return "Create Array";
    }
}

