/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.memory;

import ghidra.app.cmd.memory.MoveBlockListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.program.util.ProgramTask;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.RollbackException;
import ghidra.util.task.TaskMonitor;

public class MoveBlockTask
extends ProgramTask {
    private Address currentStart;
    private Address newStart;
    private MoveBlockListener listener;
    private boolean cancelled;
    private String statusMessage;
    private boolean success;

    public MoveBlockTask(Program program, Address currentStart, Address newStart, MoveBlockListener listener) {
        super(program, "Move Block", true, false, true);
        this.currentStart = currentStart;
        this.newStart = newStart;
        this.listener = listener;
    }

    protected void doRun(TaskMonitor monitor) {
        Memory mem = this.program.getMemory();
        MemoryBlock block = mem.getBlock(this.currentStart);
        monitor.setMessage("Moving Memory Block ...");
        this.statusMessage = "";
        Throwable cause = null;
        try {
            mem.moveBlock(block, this.newStart, monitor);
            if (!monitor.isCancelled()) {
                this.success = true;
                this.listener.moveBlockCompleted(this);
                return;
            }
            this.cancelled = true;
        }
        catch (OutOfMemoryError e) {
            this.statusMessage = "Insufficient memory to complete operation";
            cause = e;
        }
        catch (NotFoundException e) {
            this.statusMessage = "Memory block not found";
            cause = e;
        }
        catch (MemoryBlockException | MemoryConflictException | IllegalArgumentException e) {
            this.statusMessage = e.getMessage();
            cause = e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + t.getMessage()), (Throwable)t);
            this.statusMessage = t.getMessage();
            if (this.statusMessage == null) {
                this.statusMessage = t.toString();
            }
            cause = t;
        }
        this.listener.moveBlockCompleted(this);
        throw new RollbackException(this.statusMessage, cause);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean wasSuccessful() {
        return this.success;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }
}

