/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.DockingCheckBoxMenuItem;
import docking.action.ToggleDockingActionIf;
import docking.menu.DockingCheckboxMenuItemUI;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.MenuItemUI;

public class HexNumbersAction
extends CompositeEditorTableAction
implements ToggleDockingActionIf {
    private static final String ACTION_NAME = "Show Numbers In Hex";
    private static final String GROUP_NAME = "2_DATA_EDITOR_ACTION";
    private static final String defaultDescription = "Show Numbers in Hexadecimal";
    private static String[] defaultPath = new String[]{"Show Numbers in Hexadecimal"};
    private boolean isSelected;

    public HexNumbersAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Show Numbers In Hex", GROUP_NAME, defaultPath, defaultPath, null);
        this.setDescription(defaultDescription);
        this.setEnabled(true);
        this.setSelected(this.model.isShowingNumbersInHex());
    }

    public void actionPerformed(ActionContext context) {
        this.model.displayNumbersInHex(!this.model.isShowingNumbersInHex());
    }

    @Override
    public void adjustEnablement() {
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean newValue) {
        this.isSelected = newValue;
        this.firePropertyChanged("selectState", !this.isSelected, this.isSelected);
    }

    protected JMenuItem doCreateMenuItem() {
        DockingCheckBoxMenuItem menuItem = new DockingCheckBoxMenuItem(this.isSelected);
        menuItem.setUI((MenuItemUI)((DockingCheckboxMenuItemUI)DockingCheckboxMenuItemUI.createUI((JComponent)menuItem)));
        return menuItem;
    }
}

