/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.actions.SyncAction;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.HelpLocation;
import java.util.List;

public class CommitAction
extends SyncAction {
    public static final String MENU_NAME = "Commit Datatypes To";

    public CommitAction(DataTypeManagerPlugin plugin, DataTypeManagerHandler dataTypeManagerHandler, DataTypeManager dtm, ArchiveNode archiveNode, SourceArchive sourceArchive, boolean isEnabled) {
        super("Commit Changes To Archive", plugin, dataTypeManagerHandler, dtm, archiveNode, sourceArchive, isEnabled);
        this.setPopupMenuData(new MenuData(new String[]{MENU_NAME, sourceArchive.getName()}));
        this.setHelpLocation(new HelpLocation(plugin.getName(), this.getHelpTopic()));
    }

    @Override
    protected int getMenuOrder() {
        return 2;
    }

    @Override
    protected String getHelpTopic() {
        return "Commit_Data_Types";
    }

    @Override
    protected boolean isAppropriateForAction(DataTypeSyncInfo info) {
        switch (info.getSyncState()) {
            case COMMIT: 
            case CONFLICT: 
            case ORPHAN: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isPreselectedForAction(DataTypeSyncInfo info) {
        return info.getSyncState() == DataTypeSyncState.COMMIT;
    }

    @Override
    protected String getOperationName() {
        return "Commit";
    }

    @Override
    protected void applyOperation(DataTypeSyncInfo info) {
        info.commit();
    }

    @Override
    protected String getConfirmationMessage(List<DataTypeSyncInfo> infos) {
        StringBuffer buf = new StringBuffer();
        if (this.containsConflicts(infos)) {
            buf.append("You are committing one or more conflicts which will OVERWRITE\n");
            buf.append("changes in the source archive!\n\n");
        }
        buf.append("Are you sure you want to COMMIT " + infos.size() + " datatype(s)?");
        return buf.toString();
    }

    @Override
    protected boolean requiresArchiveOpenForEditing() {
        return true;
    }

    @Override
    protected String getTitle(String sourceName, String clientName) {
        return "Commit Datatype Changes From \"" + clientName + "\" To Archive \"" + sourceName + "\"";
    }
}

