/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.dialogs.InputDialog;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.framework.plugintool.PluginTool;

public class FindDataTypesAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public FindDataTypesAction(DataTypeManagerPlugin plugin) {
        super("Find Data Types", plugin.getName());
        this.plugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{"Find Data Types by Name..."}, null, "VeryLast", -1, "1"));
        this.setKeyBindingData(new KeyBindingData(70, 128));
        this.setEnabled(true);
    }

    public void actionPerformed(ActionContext context) {
        InputDialog inputDialog = new InputDialog("Find Data Types", "Please enter the search string: ");
        PluginTool tool = this.plugin.getTool();
        tool.showDialog((DialogComponentProvider)inputDialog);
        if (inputDialog.isCanceled()) {
            return;
        }
        String searchString = inputDialog.getValue();
        String title = "Find Data Type";
        DataTypesProvider newProvider = this.plugin.createProvider();
        newProvider.setIncludeDataTypeMembersInFilter(this.plugin.includeDataMembersInSearch());
        newProvider.setTitle(title);
        newProvider.setFilterText(searchString);
        newProvider.setVisible(true);
    }
}

