/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.widgets.table.AbstractGTableModel;
import ghidra.app.plugin.core.function.editor.FunctionEditorModel;
import ghidra.app.plugin.core.function.editor.FunctionVariableData;
import ghidra.app.plugin.core.function.editor.ParamInfo;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.VariableStorage;
import java.util.ArrayList;
import java.util.List;

class ParameterTableModel
extends AbstractGTableModel<FunctionVariableData> {
    private List<ParamCol> columns;
    private List<FunctionVariableData> rowDataList = new ArrayList<FunctionVariableData>();
    private FunctionEditorModel functionModel;
    private boolean canCustomizeStorage;

    ParameterTableModel(FunctionEditorModel functionModel) {
        this.functionModel = functionModel;
        this.setParameters(functionModel.getParameters(), functionModel.getFormalReturnType(), functionModel.getReturnStorage());
        this.columns = new ArrayList<ParamCol>();
        this.columns.add(new ParameterIndexColumn());
        this.columns.add(new DataTypeColumn());
        this.columns.add(new NameColumn());
        this.columns.add(new StorageColumn());
    }

    public String getName() {
        return "Parameters";
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get(columnIndex).getColumnClass();
    }

    public List<FunctionVariableData> getModelData() {
        return this.rowDataList;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).isCellEditable(rowIndex);
    }

    public int getPreferredColumnWidth(int columnIndex) {
        return this.columns.get(columnIndex).getPreferredSize();
    }

    public String getColumnName(int column) {
        return this.columns.get(column).getName();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        FunctionVariableData rowData = this.rowDataList.get(rowIndex);
        ParamCol paramCol = this.columns.get(columnIndex);
        paramCol.setValue(rowData, aValue);
    }

    public Object getColumnValueForRow(FunctionVariableData rowData, int columnIndex) {
        return this.columns.get(columnIndex).getValueForRow(rowData);
    }

    public List<ParamInfo> getParameters() {
        ArrayList<ParamInfo> list = new ArrayList<ParamInfo>();
        for (FunctionVariableData rowData : this.rowDataList) {
            if (!(rowData instanceof ParameterRowData)) continue;
            list.add(((ParameterRowData)rowData).getParamInfo());
        }
        return list;
    }

    public void setParameters(List<ParamInfo> parameterList, DataType returnDataType, VariableStorage returnStorage) {
        this.rowDataList.clear();
        this.rowDataList.add(new ReturnRowData(returnDataType, returnStorage));
        List<ParamInfo> parameters = this.functionModel.getParameters();
        for (ParamInfo paramInfo : parameters) {
            this.rowDataList.add(new ParameterRowData(paramInfo));
        }
        this.fireTableDataChanged();
    }

    public void setAllowStorageEditing(boolean canCustomizeStorage) {
        this.canCustomizeStorage = canCustomizeStorage;
    }

    class ReturnRowData
    implements FunctionVariableData {
        private DataType formalDataType;
        private VariableStorage storage;

        ReturnRowData(DataType formalDataType, VariableStorage storage) {
            this.formalDataType = formalDataType;
            this.storage = storage;
        }

        @Override
        public Integer getIndex() {
            return null;
        }

        @Override
        public VariableStorage getStorage() {
            return this.storage;
        }

        @Override
        public String getName() {
            return "<RETURN>";
        }

        @Override
        public DataType getFormalDataType() {
            return this.formalDataType;
        }

        @Override
        public void setFormalDataType(DataType dataType) {
            ParameterTableModel.this.functionModel.setFormalReturnType(dataType);
        }

        @Override
        public void setStorage(VariableStorage storage) {
            ParameterTableModel.this.functionModel.setReturnStorage(storage);
        }

        @Override
        public void setName(String name) {
        }
    }

    class ParameterRowData
    implements FunctionVariableData {
        private ParamInfo param;

        ParameterRowData(ParamInfo paramInfo) {
            this.param = paramInfo;
        }

        public ParamInfo getParamInfo() {
            return this.param;
        }

        @Override
        public Integer getIndex() {
            return this.param.getOrdinal() + 1;
        }

        @Override
        public VariableStorage getStorage() {
            return this.param.getStorage();
        }

        @Override
        public String getName() {
            return this.param.getName();
        }

        @Override
        public DataType getFormalDataType() {
            return this.param.getFormalDataType();
        }

        @Override
        public void setFormalDataType(DataType dataType) {
            ParameterTableModel.this.functionModel.setParameterFormalDataType(this.param, dataType);
        }

        @Override
        public void setName(String name) {
            ParameterTableModel.this.functionModel.setParameterName(this.param, name);
        }

        @Override
        public void setStorage(VariableStorage storage) {
            ParameterTableModel.this.functionModel.setParameterStorage(this.param, storage);
        }
    }

    private class StorageColumn
    extends ParamCol {
        public StorageColumn() {
            super("Storage", 140, VariableStorage.class, true);
        }

        @Override
        public boolean isCellEditable(int rowIndex) {
            return ParameterTableModel.this.canCustomizeStorage;
        }

        @Override
        public Object getValueForRow(FunctionVariableData rowData) {
            return rowData.getStorage();
        }

        @Override
        public void setValue(FunctionVariableData rowData, Object aValue) {
            rowData.setStorage((VariableStorage)aValue);
        }
    }

    private class NameColumn
    extends ParamCol {
        public NameColumn() {
            super("Name", 140, String.class, true);
        }

        @Override
        public boolean isCellEditable(int rowIndex) {
            FunctionVariableData rowData = (FunctionVariableData)ParameterTableModel.this.getRowObject(rowIndex);
            VariableStorage storage = rowData.getStorage();
            return rowIndex != 0 && !storage.isAutoStorage();
        }

        @Override
        public Object getValueForRow(FunctionVariableData rowData) {
            return rowData.getName();
        }

        @Override
        public void setValue(FunctionVariableData rowData, Object aValue) {
            rowData.setName(((String)aValue).trim());
        }
    }

    private class DataTypeColumn
    extends ParamCol {
        public DataTypeColumn() {
            super("Datatype", 140, DataType.class, true);
        }

        @Override
        public boolean isCellEditable(int rowIndex) {
            FunctionVariableData rowData = (FunctionVariableData)ParameterTableModel.this.getRowObject(rowIndex);
            VariableStorage storage = rowData.getStorage();
            return !storage.isAutoStorage();
        }

        @Override
        public Object getValueForRow(FunctionVariableData rowData) {
            return rowData.getFormalDataType();
        }

        @Override
        public void setValue(FunctionVariableData rowData, Object aValue) {
            rowData.setFormalDataType((DataType)aValue);
        }
    }

    private class ParameterIndexColumn
    extends ParamCol {
        public ParameterIndexColumn() {
            super("Index", 20, Object.class, false);
        }

        @Override
        public Object getValueForRow(FunctionVariableData rowData) {
            return rowData.getIndex();
        }
    }

    private abstract class ParamCol {
        private String name;
        private boolean isEditable;
        private Class<?> classType;
        private int preferredSize;

        public ParamCol(String name, int preferredSize, Class<?> classType, boolean isEditable) {
            this.name = name;
            this.preferredSize = preferredSize;
            this.isEditable = isEditable;
            this.classType = classType;
        }

        public int getPreferredSize() {
            return this.preferredSize;
        }

        public Class<?> getColumnClass() {
            return this.classType;
        }

        public void setValue(FunctionVariableData rowData, Object aValue) {
        }

        public abstract Object getValueForRow(FunctionVariableData var1);

        public boolean isCellEditable(int rowIndex) {
            return this.isEditable;
        }

        public String getName() {
            return this.name;
        }
    }
}

